/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Flash {
    private double ticks = -1.0;
    private Minecraft minecraft;
    private static final ResourceLocation texloc = new ResourceLocation("floocraftft", "textures/gui/flash.png");
    private TextureManager textureManager;
    private long startTime;
    private float yawDirectionStrength;
    private float pitchDirectionStrength;
    private float rollDirectionStrength;

    public void start() {
        if (this.ticks == -1.0) {
            this.ticks = 0.0;
            this.minecraft = Minecraft.func_71410_x();
            this.textureManager = this.minecraft.func_110434_K();
            MinecraftForge.EVENT_BUS.register((Object)this);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)FloocraftBase.TP, (float)1.0f));
            this.startTime = System.currentTimeMillis();
            Random rand = this.minecraft.field_71441_e.field_73012_v;
            this.yawDirectionStrength = (rand.nextBoolean() ? 1.0f : -1.0f) * (45.0f + rand.nextFloat() * 30.0f);
            this.pitchDirectionStrength = (rand.nextBoolean() ? 1.0f : -1.0f) * (45.0f + rand.nextFloat() * 30.0f);
            this.rollDirectionStrength = (rand.nextBoolean() ? 1.0f : -1.0f) * (45.0f + rand.nextFloat() * 30.0f);
        }
    }

    @SubscribeEvent
    public void flash(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.ticks = System.currentTimeMillis() - this.startTime;
            GlStateManager.func_227700_d_();
            GlStateManager.func_227731_j_();
            GlStateManager.func_227667_a_((boolean)false);
            GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.cos(Math.toRadians(this.ticks * 90.0 / 1000.0))));
            this.textureManager.func_110577_a(texloc);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double width = this.minecraft.func_228018_at_().func_198107_o();
            double height = this.minecraft.func_228018_at_().func_198087_p();
            bufferbuilder.func_225582_a_(width, height, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_(width, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, height, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_227667_a_((boolean)true);
            GlStateManager.func_227734_k_();
            GlStateManager.func_227709_e_();
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.ticks > 2999.0) {
            this.ticks = -1.0;
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent
    public void dizzy(EntityViewRenderEvent.CameraSetup event) {
        float angle = (float)(this.ticks / 3000.0 * Math.PI * 3.0);
        this.yawDirectionStrength *= 0.995f;
        this.pitchDirectionStrength *= 0.995f;
        this.rollDirectionStrength *= 0.995f;
        event.setYaw((float)((double)this.minecraft.field_71439_g.field_70177_z + (double)this.yawDirectionStrength * Math.sin(angle)));
        event.setPitch((float)((double)this.minecraft.field_71439_g.field_70125_A + (double)this.pitchDirectionStrength * Math.sin(angle)));
        event.setRoll((float)((double)this.rollDirectionStrength * Math.sin(angle)));
    }
}

