/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageEndPeek;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PeekScreen
extends Screen {
    private boolean peekerSpawned = false;
    private String fireplaceName;
    private Button doneBtn;
    private Entity player;
    private UUID peekerID;
    private boolean peekFailedOutOfRange;

    public PeekScreen(String name, UUID peekerID) {
        super((ITextComponent)new StringTextComponent(name));
        this.fireplaceName = name;
        this.peekerID = peekerID;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.peekFailedOutOfRange = false;
    }

    public void init() {
        this.buttons.clear();
        this.minecraft.field_195559_v.func_197967_a(true);
        if (!this.peekerSpawned) {
            PeekerEntity ep = (PeekerEntity)FloocraftBase.proxy.getEntityWithUUID((World)this.minecraft.field_71441_e, this.peekerID);
            if (ep == null) {
                this.peekFailedOutOfRange = true;
            } else {
                this.peekerSpawned = true;
                this.player = this.minecraft.func_175606_aa();
                this.minecraft.func_175607_a((Entity)ep);
            }
        }
        this.doneBtn = new Button(this.width / 2 - 100, this.height - 40, 200, 20, I18n.func_135052_a((String)"gui.peek.done", (Object[])new Object[0]), button -> {
            this.onClose();
            Minecraft.func_71410_x().func_147108_a(null);
        });
        this.addButton((Widget)this.doneBtn);
        this.doneBtn.active = true;
    }

    public void onClose() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        this.minecraft.field_195559_v.func_197967_a(false);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        proxy.overrideTicker.start();
        this.minecraft.func_175607_a(this.player);
        MessageEndPeek mep = new MessageEndPeek();
        mep.peekerUUID = this.peekerID;
        MessageHandler.INSTANCE.sendToServer((Object)mep);
        super.onClose();
    }

    public boolean charTyped(char par1, int par2) {
        if (par2 == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(int mousex, int mousey, float partialticks) {
        this.drawCenteredString(this.font, this.peekerSpawned ? I18n.func_135052_a((String)"gui.peek.peeking", (Object[])new Object[]{this.fireplaceName}) : (this.peekFailedOutOfRange ? I18n.func_135052_a((String)"gui.peek.outofrange", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.peek.waiting", (Object[])new Object[0])), this.width / 2, 15, 0xFFFFFF);
        super.render(mousex, mousey, partialticks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent lhe) {
        if (lhe.getEntity() == this.player) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent lde) {
        if (lde.getEntity() == this.player) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }
}

