/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.client.gui;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.PeekScreen;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceListRequest;
import com.fredtargaryen.floocraft.network.messages.MessagePeekRequest;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import com.fredtargaryen.floocraft.network.messages.MessageTeleportEntity;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class TeleportScreen
extends Screen {
    private static final String screenTitle = I18n.func_135052_a((String)"gui.teleport.title", (Object[])new Object[0]);
    private String status;
    private Button peekBtn;
    private Button goBtn;
    private Button cancelBtn;
    private boolean[] enabledList;
    private boolean receivedLists;
    private PlaceScrollWindow scrollWindow;
    private final int initX;
    private final int initY;
    private final int initZ;
    private Object[] placeList;
    private int peekAttemptTimer;

    public TeleportScreen(int x, int y, int z) {
        super((ITextComponent)new StringTextComponent(screenTitle));
        this.initX = x;
        this.initY = y;
        this.initZ = z;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.peekAttemptTimer = 0;
        this.refresh();
    }

    public void init() {
        this.buttons.clear();
        this.minecraft.field_195559_v.func_197967_a(true);
        Button refreshButton = new Button(this.width - 100, 0, 98, 20, I18n.func_135052_a((String)"gui.teleport.refresh", (Object[])new Object[0]), button -> {
            this.refresh();
            this.init();
        });
        refreshButton.active = false;
        this.peekBtn = new Button(this.width / 2 - 151, this.height - 40, 98, 20, I18n.func_135052_a((String)"gui.teleport.peek", (Object[])new Object[0]), button -> {
            String dest = (String)this.placeList[((GuiPlaceEntry)this.scrollWindow.getSelected()).id];
            try {
                MessagePeekRequest m = new MessagePeekRequest();
                m.initX = this.initX;
                m.initY = this.initY;
                m.initZ = this.initZ;
                m.dest = dest;
                MessageHandler.INSTANCE.sendToServer((Object)m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.addButton((Widget)this.peekBtn);
        this.peekBtn.active = false;
        this.goBtn = new Button(this.width / 2 - 49, this.height - 40, 98, 20, I18n.func_135052_a((String)"gui.teleport.go", (Object[])new Object[0]), button -> {
            int initX = this.initX;
            int initY = this.initY;
            int initZ = this.initZ;
            String dest = (String)this.placeList[((GuiPlaceEntry)this.scrollWindow.getSelected()).id];
            try {
                MessageTeleportEntity m = new MessageTeleportEntity();
                m.initX = initX;
                m.initY = initY;
                m.initZ = initZ;
                m.dest = dest;
                MessageHandler.INSTANCE.sendToServer((Object)m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cancelBtn.onClick(0.0, 0.0);
        });
        this.addButton((Widget)this.goBtn);
        this.goBtn.active = false;
        this.cancelBtn = new Button(this.width / 2 + 53, this.height - 40, 98, 20, I18n.func_135052_a((String)"gui.teleport.cancel", (Object[])new Object[0]), button -> {
            ((ClientProxy)FloocraftBase.proxy).overrideTicker.start();
            this.minecraft.func_147108_a(null);
        });
        this.addButton((Widget)this.cancelBtn);
        if (this.receivedLists) {
            refreshButton.active = true;
            this.scrollWindow = new PlaceScrollWindow();
            this.children.add(this.scrollWindow);
        }
        this.addButton((Widget)refreshButton);
    }

    public void onClose() {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        this.minecraft.field_195559_v.func_197967_a(false);
        proxy.overrideTicker.start();
        super.onClose();
    }

    public void tick() {
        super.tick();
        if (!this.receivedLists) {
            this.status = I18n.func_135052_a((String)"gui.teleport.loading", (Object[])new Object[0]);
        } else if (this.placeList.length == 0) {
            this.status = I18n.func_135052_a((String)"gui.teleport.empty", (Object[])new Object[0]);
        } else if (this.peekAttemptTimer == 0) {
            this.status = "";
        }
        if (this.peekAttemptTimer > 0) {
            --this.peekAttemptTimer;
        }
    }

    public boolean charTyped(char par1, int par2) {
        if (par2 == 1) {
            this.cancelBtn.onClick(0.0, 0.0);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(int mousex, int mousey, float partialticks) {
        this.drawCenteredString(this.font, this.status, this.width / 2, this.height / 4 + 48, 0xC8C8C8);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2), (float)0.0f, (float)50.0f);
        float f1 = 93.75f;
        GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (this.scrollWindow != null) {
            this.scrollWindow.render(mousex, mousey, partialticks);
        }
        this.drawCenteredString(this.font, screenTitle, this.width / 2, 15, 0xFFFFFF);
        super.render(mousex, mousey, partialticks);
    }

    private void refresh() {
        this.children.remove((Object)this.scrollWindow);
        this.scrollWindow = null;
        this.placeList = new Object[0];
        this.enabledList = new boolean[0];
        this.receivedLists = false;
        MessageHandler.INSTANCE.sendToServer((Object)new MessageFireplaceListRequest());
    }

    public void onFireplaceList(MessageFireplaceList m) {
        try {
            this.placeList = m.places;
            this.enabledList = m.enabledList;
            this.receivedLists = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init();
    }

    public void onStartPeek(MessageStartPeek msp) {
        this.minecraft.func_147108_a((Screen)new PeekScreen((String)this.placeList[((GuiPlaceEntry)this.scrollWindow.getSelected()).id], msp.peekerUUID));
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.scrollWindow != null) {
            this.scrollWindow.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    class PlaceScrollWindow
    extends ExtendedList<GuiPlaceEntry> {
        PlaceScrollWindow() {
            super(TeleportScreen.this.minecraft, TeleportScreen.this.width, TeleportScreen.this.height, 32, TeleportScreen.this.height - 64, 18);
            this.setRenderSelection(true);
            for (int i = 0; i < TeleportScreen.this.placeList.length; ++i) {
                this.addEntry((AbstractList.AbstractListEntry)new GuiPlaceEntry(i));
            }
            if (TeleportScreen.this.placeList.length > 0) {
                this.setSelected((GuiPlaceEntry)null);
            }
        }

        public int getWidth() {
            return 380;
        }

        public void setSelected(GuiPlaceEntry entry) {
            super.setSelected((AbstractList.AbstractListEntry)entry);
            if (entry != null) {
                boolean enabled;
                ((TeleportScreen)TeleportScreen.this).goBtn.active = enabled = TeleportScreen.this.enabledList[entry.id];
                ((TeleportScreen)TeleportScreen.this).peekBtn.active = enabled;
            }
        }

        protected boolean isSelected(int id) {
            return id == ((GuiPlaceEntry)this.getSelected()).id;
        }

        protected int getContentHeight() {
            return this.getHeight() * 18;
        }

        protected void renderBackground() {
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            int i = this.getScrollbarPosition();
            int j = i + 6;
            RenderSystem.disableLighting();
            RenderSystem.disableFog();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int k = this.getRowLeft();
            int l = this.y0 + 4 - (int)this.getScrollAmount();
            if (this.renderHeader) {
                this.renderHeader(k, l, tessellator);
            }
            this.renderList(k, l, mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ZERO.field_225655_p_, (int)GlStateManager.DestFactor.ONE.field_225654_o_);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            int i1 = 4;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.x0, (double)(this.y0 + 4), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)(this.y0 + 4), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x1, (double)(this.y1 - 4), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            bufferbuilder.func_225582_a_((double)this.x0, (double)(this.y1 - 4), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            int j1 = Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
                int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)j, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_225582_a_((double)i, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)(j - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_225582_a_((double)i, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            this.renderDecorations(mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            this.flooverlayBackground(0, this.getTop());
            this.flooverlayBackground(this.getBottom(), this.height);
        }

        private void flooverlayBackground(int p_148136_1_, int p_148136_2_) {
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            TeleportScreen.this.minecraft.func_110434_K().func_110577_a(DataReference.TP_BACKGROUND);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            wr.func_225582_a_(0.0, (double)p_148136_2_, 0.0).func_225583_a_(0.0f, (float)p_148136_2_ / f).func_181675_d();
            wr.func_225582_a_((double)this.width, (double)p_148136_2_, 0.0).func_225583_a_((float)this.width / f, (float)p_148136_2_ / f).func_181675_d();
            wr.func_225582_a_((double)this.width, (double)p_148136_1_, 0.0).func_225583_a_((float)this.width / f, (float)p_148136_1_ / f).func_181675_d();
            wr.func_225582_a_(0.0, (double)p_148136_1_, 0.0).func_225583_a_(0.0f, (float)p_148136_1_ / f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class GuiPlaceEntry
    extends ExtendedList.AbstractListEntry<GuiPlaceEntry> {
        private int id;

        GuiPlaceEntry(int id) {
            this.id = id;
        }

        public void render(int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean b, float partialTicks) {
            TeleportScreen.this.drawCenteredString(TeleportScreen.this.font, (String)TeleportScreen.this.placeList[this.id], TeleportScreen.this.width / 2, top + 3, TeleportScreen.this.enabledList[this.id] ? 65280 : 0xFF0000);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            TeleportScreen.this.scrollWindow.setSelected(this);
            return true;
        }
    }
}

