/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.entity;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageEndPeek;
import com.fredtargaryen.floocraft.network.messages.MessagePlayerIDRequest;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PeekerEntity
extends Entity {
    private UUID playerUUID;
    private ResourceLocation texture;
    private boolean sentRequest;

    public PeekerEntity(World w) {
        super(FloocraftBase.PEEKER_TYPE, w);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.texture = null;
        this.sentRequest = false;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPeekerData(PlayerEntity player, BlockPos spawnPos, Direction direction) {
        BlockPos landPos = spawnPos.func_177972_a(direction);
        float x = (float)landPos.func_177958_n() + 0.5f;
        float y = landPos.func_177956_o();
        float z = (float)landPos.func_177952_p() + 0.5f;
        switch (direction) {
            case NORTH: {
                z += 0.5f;
                break;
            }
            case SOUTH: {
                z -= 0.5f;
                break;
            }
            case EAST: {
                x -= 0.5f;
                break;
            }
            default: {
                x = (float)((double)x + 0.5);
            }
        }
        this.playerUUID = player.func_110124_au();
        this.func_70012_b(x, y, z, this.getYawFromDirection(direction), 0.0f);
    }

    public void setPlayerUUID(UUID uuid) {
        this.playerUUID = uuid;
    }

    private float getYawFromDirection(Direction ef) {
        switch (ef) {
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
        }
        return 90.0f;
    }

    public void func_70106_y() {
        super.func_70106_y();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public void func_70071_h_() {
        PlayerEntity player;
        if (!(this.field_70170_p.field_72995_K || (player = (PlayerEntity)((ServerWorld)this.field_70170_p).func_217461_a(this.playerUUID)) != null && player.func_70089_S())) {
            this.func_70106_y();
        }
    }

    public ResourceLocation getTexture() {
        if (this.playerUUID == null) {
            if (this.field_70170_p.field_72995_K && !this.sentRequest) {
                MessagePlayerIDRequest mpidr = new MessagePlayerIDRequest();
                mpidr.peekerUUID = this.func_110124_au();
                MessageHandler.INSTANCE.sendToServer((Object)mpidr);
            }
            return null;
        }
        if (this.texture == null && this.field_70170_p.field_72995_K) {
            this.texture = ((AbstractClientPlayerEntity)this.field_70170_p.func_217371_b(this.playerUUID)).func_110306_p();
        }
        return this.texture;
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent lhe) {
        UUID hurtEntityUUID;
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.playerUUID != null && (hurtEntityUUID = lhe.getEntity().func_110124_au()).equals(this.playerUUID)) {
            MessageEndPeek mep = new MessageEndPeek();
            mep.peekerUUID = this.func_110124_au();
            MessageHandler.INSTANCE.sendToServer((Object)mep);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent lde) {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K && this.playerUUID != null && lde.getEntity().func_110124_au().equals(this.playerUUID)) {
            MessageEndPeek mep = new MessageEndPeek();
            mep.peekerUUID = this.func_110124_au();
            MessageHandler.INSTANCE.sendToServer((Object)mep);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.playerUUID = new UUID(compound.func_74763_f("msb"), compound.func_74763_f("lsb"));
        this.func_70101_b(compound.func_74760_g("yaw"), 0.0f);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74772_a("msb", this.playerUUID.getMostSignificantBits());
        compound.func_74772_a("lsb", this.playerUUID.getLeastSignificantBits());
        compound.func_74776_a("yaw", this.field_70177_z);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

