/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessagePeekRequest {
    public int initX;
    public int initY;
    public int initZ;
    public String dest;
    private static final Charset defaultCharset = Charset.defaultCharset();

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int initX = this.initX;
            int initY = this.initY;
            int initZ = this.initZ;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            Block initBlock = world.func_180495_p(new BlockPos(initX, initY, initZ)).func_177230_c();
            int[] destCoords = FloocraftWorldData.forWorld((World)world).placeList.get(this.dest);
            if (destCoords[0] != this.initX || destCoords[1] != this.initY || destCoords[2] != this.initZ) {
                Direction.Axis axis;
                Direction direction;
                BlockPos dest;
                Block destBlock;
                int destX = destCoords[0];
                int destY = destCoords[1];
                int destZ = destCoords[2];
                if (!(initBlock != FloocraftBase.GREEN_FLAMES_BUSY && initBlock != FloocraftBase.GREEN_FLAMES_IDLE || (destBlock = world.func_180495_p(dest = new BlockPos(destX, destY, destZ)).func_177230_c()) != Blocks.field_150480_ab && destBlock != FloocraftBase.GREEN_FLAMES_BUSY && destBlock != FloocraftBase.GREEN_FLAMES_IDLE || (direction = ((GreenFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP).isInFireplace(world, dest)) == null || (axis = direction.func_176740_k()) != Direction.Axis.X && axis != Direction.Axis.Z)) {
                    PeekerEntity peeker = new PeekerEntity(world);
                    peeker.setPeekerData((PlayerEntity)player, dest, direction);
                    world.func_217376_c((Entity)peeker);
                    MessageStartPeek msp = new MessageStartPeek(peeker.func_110124_au());
                    MessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msp);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessagePeekRequest() {
    }

    public MessagePeekRequest(ByteBuf buf) {
        this.initX = buf.readInt();
        this.initY = buf.readInt();
        this.initZ = buf.readInt();
        this.dest = buf.readBytes(buf.readInt()).toString(defaultCharset);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.initX);
        buf.writeInt(this.initY);
        buf.writeInt(this.initZ);
        buf.writeInt(this.dest.length());
        buf.writeBytes(this.dest.getBytes());
    }
}

