/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessagePlayerID;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessagePlayerIDRequest {
    public UUID peekerUUID;

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity spe = ((NetworkEvent.Context)ctx.get()).getSender();
            PeekerEntity pe = (PeekerEntity)spe.func_71121_q().func_217461_a(this.peekerUUID);
            MessagePlayerID mpID = new MessagePlayerID(this.peekerUUID, pe.getPlayerUUID());
            MessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> spe), (Object)mpID);
        });
        ctx.get().setPacketHandled(true);
    }

    public MessagePlayerIDRequest() {
    }

    public MessagePlayerIDRequest(ByteBuf buf) {
        this.peekerUUID = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.peekerUUID.getMostSignificantBits());
        buf.writeLong(this.peekerUUID.getLeastSignificantBits());
    }
}

