/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network.messages;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.network.FloocraftWorldData;
import com.fredtargaryen.floocraft.network.MessageHandler;
import com.fredtargaryen.floocraft.network.messages.MessageDoGreenFlash;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageTeleportEntity {
    public int initX;
    public int initY;
    public int initZ;
    public String dest;
    private static final Charset defaultCharset = Charset.defaultCharset();

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            boolean validDest = false;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            int[] destCoords = FloocraftWorldData.forWorld((World)world).placeList.get(this.dest);
            if (destCoords[0] != this.initX || destCoords[1] != this.initY || destCoords[2] != this.initZ) {
                BlockPos destBlockPos = new BlockPos(destCoords[0], destCoords[1], destCoords[2]);
                Block destBlock = world.func_180495_p(destBlockPos).func_177230_c();
                if (destBlock == Blocks.field_150480_ab) {
                    validDest = ((GreenFlamesBase)FloocraftBase.GREEN_FLAMES_TEMP).isInFireplace(world, destBlockPos) != null;
                } else if (destBlock == FloocraftBase.GREEN_FLAMES_BUSY || destBlock == FloocraftBase.GREEN_FLAMES_IDLE) {
                    validDest = true;
                }
                BlockPos initBlockPos = new BlockPos(this.initX, this.initY, this.initZ);
                Block initBlock = world.func_180495_p(initBlockPos).func_177230_c();
                if (validDest && (initBlock == FloocraftBase.GREEN_FLAMES_BUSY || initBlock == FloocraftBase.GREEN_FLAMES_IDLE)) {
                    if (destBlock == Blocks.field_150480_ab) {
                        world.func_175656_a(destBlockPos, FloocraftBase.GREEN_FLAMES_TEMP.func_176223_P());
                    }
                    MessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageDoGreenFlash());
                    if (player.func_184187_bx() != null) {
                        player.func_184210_p();
                    }
                    player.field_71135_a.func_147364_a((double)destCoords[0] + 0.5, (double)destCoords[1], (double)destCoords[2] + 0.5, player.func_70681_au().nextFloat() * 360.0f, player.field_70125_A);
                    player.field_70143_R = 0.0f;
                    int m = (Integer)world.func_180495_p(initBlockPos).func_177229_b((IProperty)BlockStateProperties.field_208171_X);
                    if (m < 2) {
                        world.func_175656_a(initBlockPos, Blocks.field_150480_ab.func_176223_P());
                    } else {
                        world.func_180501_a(initBlockPos, (BlockState)FloocraftBase.GREEN_FLAMES_BUSY.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(m == 9 ? 9 : m - 1)), 2);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageTeleportEntity() {
    }

    public MessageTeleportEntity(ByteBuf buf) {
        this.initX = buf.readInt();
        this.initY = buf.readInt();
        this.initZ = buf.readInt();
        this.dest = buf.readBytes(buf.readInt()).toString(defaultCharset);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.initX);
        buf.writeInt(this.initY);
        buf.writeInt(this.initZ);
        buf.writeInt(this.dest.length());
        buf.writeBytes(this.dest.getBytes());
    }
}

