/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.proxy;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.Flash;
import com.fredtargaryen.floocraft.client.gui.FlooSignScreen;
import com.fredtargaryen.floocraft.client.gui.FloowerPotScreen;
import com.fredtargaryen.floocraft.client.gui.TeleportScreen;
import com.fredtargaryen.floocraft.client.renderer.RenderPeekerFactory;
import com.fredtargaryen.floocraft.client.ticker.OverrideTicker;
import com.fredtargaryen.floocraft.entity.PeekerEntity;
import com.fredtargaryen.floocraft.network.messages.MessageApproval;
import com.fredtargaryen.floocraft.network.messages.MessageDoGreenFlash;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import com.fredtargaryen.floocraft.network.messages.MessagePlayerID;
import com.fredtargaryen.floocraft.network.messages.MessageStartPeek;
import com.fredtargaryen.floocraft.proxy.IProxy;
import com.fredtargaryen.floocraft.tileentity.renderer.TileEntityFlooSignRenderer;
import com.fredtargaryen.floocraft.tileentity.renderer.TileEntityPotRenderer;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
implements IProxy {
    public OverrideTicker overrideTicker;
    public Flash flash;

    @Override
    public void onMessage(MessageApproval ma) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof FlooSignScreen) {
            ((FlooSignScreen)s).dealWithAnswer(ma.answer);
        }
    }

    @Override
    public void onMessage(MessageDoGreenFlash mdgf) {
        this.flash.start();
    }

    @Override
    public void onMessage(MessageFireplaceList mfl) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof TeleportScreen) {
            ((TeleportScreen)s).onFireplaceList(mfl);
        }
    }

    @Override
    public void onMessage(MessageStartPeek msp) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof TeleportScreen) {
            ((TeleportScreen)s).onStartPeek(msp);
        }
    }

    @Override
    public void registerGUIs() {
        ScreenManager.func_216911_a(FloocraftBase.POT_CONTAINER_TYPE, FloowerPotScreen::new);
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntityRenderer(FloocraftBase.FIREPLACE_TYPE, TileEntityFlooSignRenderer::new);
        ClientRegistry.bindTileEntityRenderer(FloocraftBase.POT_TYPE, TileEntityPotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FloocraftBase.PEEKER_TYPE, (IRenderFactory)new RenderPeekerFactory());
    }

    @Override
    public void registerTickHandlers() {
        this.overrideTicker = new OverrideTicker();
        this.flash = new Flash();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setUUIDs(MessagePlayerID message) {
        PeekerEntity ep = (PeekerEntity)FloocraftBase.proxy.getEntityWithUUID((World)Minecraft.func_71410_x().field_71441_e, message.peekerUUID);
        ep.setPlayerUUID(message.playerUUID);
    }

    @Override
    public void setupRenderTypes() {
        RenderTypeLookup.setRenderLayer((Block)FloocraftBase.GREEN_FLAMES_BUSY, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)FloocraftBase.GREEN_FLAMES_IDLE, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)FloocraftBase.GREEN_FLAMES_TEMP, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)FloocraftBase.BLOCK_FLOO_TORCH, (RenderType)RenderType.func_228641_d_());
    }

    @Override
    public Entity getEntityWithUUID(World world, UUID uuid) {
        if (world != null && uuid != null) {
            for (Entity next : ((ClientWorld)world).func_217416_b()) {
                if (!next.func_110124_au().equals(uuid)) continue;
                return next;
            }
        }
        return null;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void stitchTextures(TextureStitchEvent.Pre tse) {
        if (tse.getMap().func_229223_g_().equals((Object)Atlases.field_228746_e_)) {
            tse.addSprite(DataReference.SIGN_TEX_LOC);
        }
    }
}

