/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.tileentity.renderer;

import com.fredtargaryen.floocraft.DataReference;
import com.fredtargaryen.floocraft.tileentity.FireplaceTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallSignBlock;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityFlooSignRenderer
extends TileEntityRenderer<FireplaceTileEntity> {
    private final FlooSignModel model = new FlooSignModel();

    public TileEntityFlooSignRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(FireplaceTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = tileEntityIn.func_195044_w();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        float yAngle = -((Direction)blockstate.func_177229_b((IProperty)WallSignBlock.field_176412_a)).func_185119_l();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yAngle));
        matrixStackIn.func_227861_a_(0.0, -0.3125, -0.4375);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        IVertexBuilder ivertexbuilder = FlooSignModel.MATERIAL.func_229311_a_(bufferIn, arg_0 -> ((FlooSignModel)this.model).func_228282_a_(arg_0));
        this.model.board.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        matrixStackIn.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStackIn.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        int colour = 0;
        for (int i = 0; i < 4; ++i) {
            String s = tileEntityIn.getString(i);
            if (s == null) continue;
            float left = -fontrenderer.func_78256_a(s) / 2;
            fontrenderer.func_228079_a_(s, left, (float)(i * 10 - tileEntityIn.signText.length * 5), colour, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class FlooSignModel
    extends Model {
        public final ModelRenderer board = new ModelRenderer(64, 32, 0, 0);
        public static final Material MATERIAL = new Material(Atlases.field_228746_e_, DataReference.SIGN_TEX_LOC);

        public FlooSignModel() {
            super(RenderType::func_228640_c_);
            this.board.func_228301_a_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f, 0.0f);
        }

        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.board.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

