/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiTeleport;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GreenFlamesBase
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)9);

    public GreenFlamesBase() {
        super(Material.field_151581_o);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180634_a(World par1World, BlockPos pos, IBlockState state, Entity par4Entity) {
        if (par4Entity instanceof EntityPlayer && par1World.field_72995_K) {
            this.doClientGuiTings(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientGuiTings(BlockPos pos) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(World par1World) {
        return 30;
    }

    public void func_176213_c(World par1World, BlockPos pos, IBlockState state) {
        if (this.isInFireplace(par1World, pos)) {
            par1World.func_175684_a(pos, (Block)this, this.func_149738_a(par1World));
        } else {
            par1World.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!this.isInFireplace(par1World, pos) || ((Integer)par1World.func_180495_p(pos).func_177229_b((IProperty)AGE)).equals(0)) {
            par1World.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        } else {
            par1World.func_175684_a(pos, (Block)this, this.func_149738_a(par1World) + par5Random.nextInt(10));
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
    }

    private int getTopBlockY(World w, BlockPos pos) {
        BlockPos newPos = pos.func_177967_a(EnumFacing.UP, 1);
        int y = newPos.func_177956_o();
        IBlockState bs = w.func_180495_p(newPos);
        while (bs.func_177230_c().isAir(bs, (IBlockAccess)w, newPos) && y < 256) {
            newPos = newPos.func_177967_a(EnumFacing.UP, 1);
            y = newPos.func_177956_o();
            bs = w.func_180495_p(newPos);
        }
        if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
            return y;
        }
        return 0;
    }

    private boolean isWallColumn(World w, BlockPos bottomPos, int topY) {
        boolean valid = true;
        BlockPos newBottomPos = bottomPos;
        while (valid && newBottomPos.func_177956_o() < topY) {
            IBlockState bs = w.func_180495_p(newBottomPos);
            if (bs.func_177230_c().func_149688_o(bs).func_76220_a()) {
                newBottomPos = newBottomPos.func_177967_a(EnumFacing.UP, 1);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<Integer> getWalls(World w, BlockPos bottomPos, int topY) {
        ArrayList<Integer> walls = new ArrayList<Integer>();
        if (this.isWallColumn(w, bottomPos.func_177963_a(0.0, 0.0, 1.0), topY)) {
            walls.add(2);
        }
        if (this.isWallColumn(w, bottomPos.func_177963_a(-1.0, 0.0, 0.0), topY)) {
            walls.add(4);
        }
        if (this.isWallColumn(w, bottomPos.func_177963_a(1.0, 0.0, 0.0), topY)) {
            walls.add(6);
        }
        if (this.isWallColumn(w, bottomPos.func_177963_a(0.0, 0.0, -1.0), topY)) {
            walls.add(8);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, int x, int y, int z, int backWall, int oldSideWall, int top) {
        int sideWall;
        int oldX = x;
        int oldZ = z;
        switch (oldSideWall) {
            case 2: {
                sideWall = 8;
                break;
            }
            case 4: {
                sideWall = 6;
                break;
            }
            case 6: {
                sideWall = 4;
                break;
            }
            case 8: {
                sideWall = 2;
                break;
            }
            default: {
                return false;
            }
        }
        boolean stop = false;
        block10: while (!stop) {
            if (backWall == 2 || backWall == 8) {
                x = sideWall == 4 ? --x : ++x;
            } else {
                z = sideWall == 2 ? ++z : --z;
            }
            BlockPos newBottomPos = new BlockPos(x, y, z);
            int newTop = this.getTopBlockY(w, newBottomPos);
            List<Integer> walls = this.getWalls(w, newBottomPos, newTop);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top++ ? !this.isWallColumn(w, new BlockPos(oldX, top, oldZ), newTop) : newTop < top-- && !this.isWallColumn(w, new BlockPos(x, newTop, z), top)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block10;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block10;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isInFireplace(World w, BlockPos pos) {
        int t;
        if (pos.func_177956_o() < 254 && (t = this.getTopBlockY(w, pos)) > 0) {
            List<Integer> walls = this.getWalls(w, pos, t);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            switch (walls.size()) {
                case 3: {
                    return true;
                }
                case 2: {
                    if ((!walls.contains(2) || !walls.contains(4) && !walls.contains(6)) && (!walls.contains(8) || !walls.contains(4) && !walls.contains(6))) break;
                    return this.canLoopToCorner(w, x, y, z, walls.get(0), walls.get(1), t) || this.canLoopToCorner(w, x, y, z, walls.get(1), walls.get(0), t);
                }
                case 1: {
                    switch (walls.get(0)) {
                        case 2: {
                            return this.canLoopToCorner(w, x, y, z, 2, 4, t) && this.canLoopToCorner(w, x, y, z, 2, 6, t);
                        }
                        case 4: {
                            return this.canLoopToCorner(w, x, y, z, 4, 8, t) && this.canLoopToCorner(w, x, y, z, 4, 2, t);
                        }
                        case 6: {
                            return this.canLoopToCorner(w, x, y, z, 6, 8, t) && this.canLoopToCorner(w, x, y, z, 6, 2, t);
                        }
                        case 8: {
                            return this.canLoopToCorner(w, x, y, z, 8, 4, t) && this.canLoopToCorner(w, x, y, z, 8, 6, t);
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }
}

