/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.block;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.client.gui.GuiTeleport;
import com.fredtargaryen.floocraft.proxy.ClientProxy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class GreenFlamesBase
extends Block {
    protected int renderID;

    public GreenFlamesBase(int renderID) {
        super(Material.field_151581_o);
        this.renderID = renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister i) {
        this.field_149761_L = i.func_94245_a("ftfloocraft:fire");
    }

    public boolean isNormalCube(IBlockAccess w, int x, int y, int z) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149670_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par5Entity instanceof EntityPlayer && par1World.field_72995_K) {
            this.doClientGuiTings(par2, par3, par4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doClientGuiTings(int x, int y, int z) {
        ClientProxy proxy = (ClientProxy)FloocraftBase.proxy;
        if (Minecraft.func_71410_x().field_71462_r == null && !proxy.overrideTicker.isOverriding()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleport(x, y, z));
            proxy.overrideTicker.start();
        }
    }

    public int func_149738_a(World par1World) {
        return 30;
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (!this.isInFireplace(par1World, par2, par3, par4)) {
            par1World.func_147449_b(par2, par3, par4, (Block)Blocks.field_150480_ab);
        } else {
            par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World));
        }
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!this.isInFireplace(par1World, par2, par3, par4) || par1World.func_72805_g(par2, par3, par4) == 0) {
            par1World.func_147449_b(par2, par3, par4, (Block)Blocks.field_150480_ab);
        } else {
            par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World) + par5Random.nextInt(10));
        }
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public int func_149645_b() {
        return this.renderID;
    }

    protected int getTopBlockY(World w, int x, int y, int z) {
        Block b;
        if ((b = w.func_147439_a(x, ++y, z)).isAir((IBlockAccess)w, x, y, z)) {
            while (b.isAir((IBlockAccess)w, x, y, z) && y < 256) {
                b = w.func_147439_a(x, ++y, z);
            }
            if (b.isNormalCube((IBlockAccess)w, x, y, z)) {
                return y;
            }
        }
        return 0;
    }

    private boolean isWallColumn(World w, int x, int bottomY, int topY, int z) {
        if (topY == 0) {
            return false;
        }
        boolean valid = true;
        while (valid && bottomY < topY) {
            if (w.func_147439_a(x, bottomY, z).isNormalCube((IBlockAccess)w, x, bottomY, z)) {
                ++bottomY;
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private List<Integer> getWalls(World w, int x, int bottomY, int topY, int z) {
        ArrayList<Integer> walls = new ArrayList<Integer>();
        if (this.isWallColumn(w, x, bottomY, topY, z + 1)) {
            walls.add(2);
        }
        if (this.isWallColumn(w, x - 1, bottomY, topY, z)) {
            walls.add(4);
        }
        if (this.isWallColumn(w, x + 1, bottomY, topY, z)) {
            walls.add(6);
        }
        if (this.isWallColumn(w, x, bottomY, topY, z - 1)) {
            walls.add(8);
        }
        return walls;
    }

    private boolean canLoopToCorner(World w, int x, int y, int z, int backWall, int oldSideWall, int top) {
        int sideWall;
        int oldX = x;
        int oldZ = z;
        switch (oldSideWall) {
            case 2: {
                sideWall = 8;
                break;
            }
            case 4: {
                sideWall = 6;
                break;
            }
            case 6: {
                sideWall = 4;
                break;
            }
            case 8: {
                sideWall = 2;
                break;
            }
            default: {
                return false;
            }
        }
        boolean stop = false;
        block10: while (!stop) {
            if (backWall == 2 || backWall == 8) {
                x = sideWall == 4 ? --x : ++x;
            } else {
                z = sideWall == 2 ? ++z : --z;
            }
            int newTop = this.getTopBlockY(w, x, y, z);
            List<Integer> walls = this.getWalls(w, x, y, newTop, z);
            switch (walls.size()) {
                case 1: {
                    if (!walls.contains(backWall)) {
                        return false;
                    }
                    if (newTop > top + 1 ? !this.isWallColumn(w, oldX, top, newTop, oldZ) : newTop < top - 1 && !this.isWallColumn(w, x, newTop, top, z)) {
                        return false;
                    }
                    oldX = x;
                    top = newTop;
                    oldZ = z;
                    continue block10;
                }
                case 2: {
                    if (walls.contains(backWall) && walls.contains(sideWall)) {
                        stop = true;
                        continue block10;
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isInFireplace(World w, int x, int y, int z) {
        if (!w.func_72937_j(x, y, z) && y < 254 && x < 30000000 && x > -30000000 && z < 30000000 && z > -30000000) {
            int t = this.getTopBlockY(w, x, y, z);
            List<Integer> walls = this.getWalls(w, x, y, t, z);
            switch (walls.size()) {
                case 3: {
                    return true;
                }
                case 2: {
                    if ((!walls.contains(2) || !walls.contains(4) && !walls.contains(6)) && (!walls.contains(8) || !walls.contains(4) && !walls.contains(6))) break;
                    return this.canLoopToCorner(w, x, y, z, walls.get(0), walls.get(1), t) || this.canLoopToCorner(w, x, y, z, walls.get(1), walls.get(0), t);
                }
                case 1: {
                    switch (walls.get(0)) {
                        case 2: {
                            return this.canLoopToCorner(w, x, y, z, 2, 4, t) && this.canLoopToCorner(w, x, y, z, 2, 6, t);
                        }
                        case 4: {
                            return this.canLoopToCorner(w, x, y, z, 4, 8, t) && this.canLoopToCorner(w, x, y, z, 4, 2, t);
                        }
                        case 6: {
                            return this.canLoopToCorner(w, x, y, z, 6, 8, t) && this.canLoopToCorner(w, x, y, z, 6, 2, t);
                        }
                        case 8: {
                            return this.canLoopToCorner(w, x, y, z, 8, 4, t) && this.canLoopToCorner(w, x, y, z, 8, 6, t);
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }
}

