/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.floocraft.network;

import com.fredtargaryen.floocraft.FloocraftBase;
import com.fredtargaryen.floocraft.block.GreenFlamesBase;
import com.fredtargaryen.floocraft.block.GreenFlamesTemp;
import com.fredtargaryen.floocraft.network.messages.MessageFireplaceList;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class FloocraftWorldData
extends WorldSavedData {
    public final List<String> placenamelist = new ArrayList<String>();
    public final List<Integer> xcoordlist = new ArrayList<Integer>();
    public final List<Integer> ycoordlist = new ArrayList<Integer>();
    public final List<Integer> zcoordlist = new ArrayList<Integer>();

    public FloocraftWorldData(String key) {
        super(key);
    }

    public static FloocraftWorldData forWorld(World world) {
        MapStorage storage = world.perWorldStorage;
        FloocraftWorldData data = (FloocraftWorldData)storage.func_75742_a(FloocraftWorldData.class, "ftfloocraft");
        if (data == null) {
            FMLLog.warning((String)"[FLOOCRAFT-SERVER] No fireplace data was found for this world. Creating new fireplace data.", (Object[])new Object[0]);
            data = new FloocraftWorldData("ftfloocraft");
            storage.func_75745_a("ftfloocraft", (WorldSavedData)data);
        }
        return data;
    }

    public void addLocation(String name, int x, int y, int z) {
        this.placenamelist.add(name);
        this.xcoordlist.add(x);
        this.ycoordlist.add(y);
        this.zcoordlist.add(z);
        FMLLog.info((String)("[FLOOCRAFT-SERVER] Added fireplace at (" + x + ", " + y + ", " + z + "). Name: " + name), (Object[])new Object[0]);
        this.func_76185_a();
    }

    public void removeLocation(int x, int y, int z) {
        int i = 0;
        int j = -1;
        while (i < this.placenamelist.size() && j == -1) {
            if (this.xcoordlist.get(i) != x || this.ycoordlist.get(i) != y || this.zcoordlist.get(i) != z) {
                ++i;
                continue;
            }
            j = i;
        }
        if (j > -1) {
            FMLLog.info((String)("[FLOOCRAFT-SERVER] Removed fireplace at (" + x + ", " + y + ", " + z + "). Name: " + this.placenamelist.get(j)), (Object[])new Object[0]);
            this.placenamelist.remove(j);
            this.xcoordlist.remove(j);
            this.ycoordlist.remove(j);
            this.zcoordlist.remove(j);
        } else {
            FMLLog.warning((String)("[FLOOCRAFT-SERVER] Failed to remove fireplace at (" + x + ", " + y + ", " + z + ")."), (Object[])new Object[0]);
            FMLLog.warning((String)"[FLOOCRAFT-SERVER] Data can be manually removed with an NBT editor.", (Object[])new Object[0]);
        }
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("ftfloocraft", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(i);
            this.xcoordlist.add(nbt1.func_74762_e("X"));
            this.ycoordlist.add(nbt1.func_74762_e("Y"));
            this.zcoordlist.add(nbt1.func_74762_e("Z"));
            this.placenamelist.add(nbt1.func_74779_i("NAME"));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.placenamelist.size(); ++i) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("NAME", this.placenamelist.get(i));
            nbt1.func_74768_a("X", this.xcoordlist.get(i).intValue());
            nbt1.func_74768_a("Y", this.ycoordlist.get(i).intValue());
            nbt1.func_74768_a("Z", this.zcoordlist.get(i).intValue());
            nbttaglist.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("ftfloocraft", (NBTBase)nbttaglist);
    }

    public MessageFireplaceList assembleNewFireplaceList(World w) {
        MessageFireplaceList m = new MessageFireplaceList();
        m.placenamelist = this.placenamelist;
        m.xcoordlist = this.xcoordlist;
        m.ycoordlist = this.ycoordlist;
        m.zcoordlist = this.zcoordlist;
        ArrayList<Boolean> l = new ArrayList<Boolean>();
        for (int x = 0; x < this.placenamelist.size(); ++x) {
            boolean ok;
            int dz;
            int dy;
            int dx = this.xcoordlist.get(x);
            Block b = w.func_147439_a(dx, dy = this.ycoordlist.get(x).intValue(), dz = this.zcoordlist.get(x).intValue());
            if (b instanceof BlockFire) {
                w.func_147449_b(dx, dy, dz, FloocraftBase.greenFlamesTemp);
                GreenFlamesTemp gfit = (GreenFlamesTemp)w.func_147439_a(dx, dy, dz);
                ok = gfit.isInFireplace(w, dx, dy, dz);
                w.func_147449_b(dx, dy, dz, (Block)Blocks.field_150480_ab);
            } else {
                ok = b instanceof GreenFlamesBase;
            }
            l.add(ok);
        }
        m.enabledlist = l;
        return m;
    }
}

