/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.flying_things.ModFlyingThings;
import ovh.corail.flying_things.network.UpdateConfigMessage;

public class ConfigFlyingThings {
    public static final Client client;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final General general;
    public static final DeniedDimensionToFly deniedDimensionToFly;
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final SharedDatas shared_datas;
    public static final ForgeConfigSpec SHARED_SPEC;

    private static String getTranslation(String name) {
        return "flying_things.config." + name;
    }

    public static UpdateConfigMessage getUpdatePacket() {
        int[] intConfigs = new int[IntConfigs.values().length];
        for (IntConfigs config : IntConfigs.values()) {
            intConfigs[config.ordinal()] = config.get();
        }
        return new UpdateConfigMessage((Boolean)ConfigFlyingThings.shared_datas.allowTombstoneSoulbound.get(), intConfigs);
    }

    public static void updateConfig(boolean allowTombstoneSoulbound, int[] intConfigs) {
        ConfigFlyingThings.shared_datas.allowTombstoneSoulbound.set((Object)allowTombstoneSoulbound);
        for (IntConfigs config : IntConfigs.values()) {
            config.set(intConfigs[config.ordinal()]);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        client = (Client)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        general = new General(BUILDER);
        deniedDimensionToFly = new DeniedDimensionToFly(BUILDER);
        GENERAL_SPEC = BUILDER.build();
        specPair = new ForgeConfigSpec.Builder().configure(SharedDatas::new);
        shared_datas = (SharedDatas)specPair.getLeft();
        SHARED_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    static enum IntConfigs {
        speedMax(ConfigFlyingThings.shared_datas.speedMax),
        accelerationMax(ConfigFlyingThings.shared_datas.accelerationMax),
        accelerationIncrement(ConfigFlyingThings.shared_datas.accelerationIncrement),
        speedMaxNoEnergy(ConfigFlyingThings.shared_datas.speedMaxNoEnergy),
        maxEnergy(ConfigFlyingThings.shared_datas.maxEnergy);

        private ForgeConfigSpec.ConfigValue<Integer> supplier;

        private IntConfigs(ForgeConfigSpec.ConfigValue<Integer> supplier) {
            this.supplier = supplier;
        }

        public int get() {
            return (Integer)this.supplier.get();
        }

        public void set(int value) {
            this.supplier.set((Object)value);
        }
    }

    @Mod.EventBusSubscriber(modid="flying_things", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ConfigEvent {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onReloadConfig(ModConfig.Reloading event) {
            if (event.getConfig().getModId().equals("flying_things") && event.getConfig().getType() == ModConfig.Type.SERVER) {
                ModFlyingThings.PROXY.markConfigDirty();
            }
        }
    }

    public static class SharedDatas {
        public final ForgeConfigSpec.ConfigValue<Integer> speedMax;
        public final ForgeConfigSpec.ConfigValue<Integer> accelerationMax;
        public final ForgeConfigSpec.ConfigValue<Integer> accelerationIncrement;
        public final ForgeConfigSpec.ConfigValue<Integer> speedMaxNoEnergy;
        public final ForgeConfigSpec.ConfigValue<Integer> maxEnergy;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowTombstoneSoulbound;

        public SharedDatas(ForgeConfigSpec.Builder builder) {
            builder.comment("Theses options are automatically sync on the client").push("shared_datas");
            this.speedMax = builder.comment("Maximum Speed [0..200|default:90]").translation(ConfigFlyingThings.getTranslation("speed_max")).defineInRange("speed_max", 90, 0, 200);
            this.accelerationMax = builder.comment("Maximum acceleration [0..100|default:35]").translation(ConfigFlyingThings.getTranslation("acceleration_max")).defineInRange("acceleration_max", 35, 0, 100);
            this.accelerationIncrement = builder.comment("Acceleration increment [1..20|default:7]").translation(ConfigFlyingThings.getTranslation("acceleration_increment")).defineInRange("acceleration_increment", 7, 1, 20);
            this.speedMaxNoEnergy = builder.comment("Maximum speed with no energy [0..300|default:30]").translation(ConfigFlyingThings.getTranslation("speed_max_no_energy")).defineInRange("speed_max_no_energy", 30, 0, 300);
            this.maxEnergy = builder.comment("Maximum energy [100..MAX|default:1000]").translation(ConfigFlyingThings.getTranslation("max_energy")).defineInRange("max_energy", 1000, 100, Integer.MAX_VALUE);
            this.allowTombstoneSoulbound = builder.comment("Allow applying Soulbound [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_tombstone_soulbound")).define("allow_tombstone_soulbound", true);
            builder.pop();
        }
    }

    public static class DeniedDimensionToFly {
        public final ForgeConfigSpec.ConfigValue<List<String>> deniedDimensionBroom;
        public final ForgeConfigSpec.ConfigValue<List<String>> deniedDimensionCarpet;

        public DeniedDimensionToFly(ForgeConfigSpec.Builder builder) {
            builder.comment("Denied dimensions to ride a flying thing - example : minecraft:the_nether").push("denied_dimensions_to_fly");
            this.deniedDimensionBroom = builder.comment("Dimensions for the brooms").translation(ConfigFlyingThings.getTranslation("denied_dimension_broom")).define("denied_dimension_broom", new ArrayList());
            this.deniedDimensionCarpet = builder.comment("Dimensions for the carpets").translation(ConfigFlyingThings.getTranslation("denied_dimension_carpet")).define("denied_dimension_carpet", new ArrayList());
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> renderEffect;
        public final ForgeConfigSpec.ConfigValue<Boolean> barValue;
        public final ForgeConfigSpec.ConfigValue<Integer> barHeightPos;
        public final ForgeConfigSpec.ConfigValue<Integer> barColorSpeed;
        public final ForgeConfigSpec.ConfigValue<Integer> barColorEnergy;
        public final ForgeConfigSpec.ConfigValue<Graduation> barGraduationEnergy;
        public final ForgeConfigSpec.ConfigValue<Graduation> barGraduationSpeed;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Theses options are custom parameters for the player").push("client");
            this.renderEffect = builder.comment("Enable rendering effects [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("render_effect")).define("render_effect", true);
            this.barValue = builder.comment("Display the bar values [false/true|default:false]").translation(ConfigFlyingThings.getTranslation("bar_value")).define("bar_value", false);
            this.barHeightPos = builder.comment("Height of the position of the bars [0..100|default:62]").translation(ConfigFlyingThings.getTranslation("bar_height_pos")).defineInRange("bar_height_pos", 62, 0, 100);
            this.barColorEnergy = builder.comment("Color of the speed bar [0..16777215|default:65280]").translation(ConfigFlyingThings.getTranslation("bar_color_energy")).defineInRange("bar_color_energy", 65280, 0, 0xFFFFFF);
            this.barColorSpeed = builder.comment("Color of the speed bar [0..16777215|default:16711680]").translation(ConfigFlyingThings.getTranslation("bar_color_speed")).defineInRange("bar_color_speed", 0xFF0000, 0, 0xFFFFFF);
            this.barGraduationEnergy = builder.comment("Type of graduation of the energy bar").translation(ConfigFlyingThings.getTranslation("bar_graduation_energy")).defineEnum("bar_graduation_energy", (Enum)Graduation.SMALLER);
            this.barGraduationSpeed = builder.comment("Type of graduation of the speed bar").translation(ConfigFlyingThings.getTranslation("bar_graduation_speed")).defineEnum("bar_graduation_speed", (Enum)Graduation.SMALLER);
            builder.pop();
        }

        public static enum Graduation {
            SMALLEST,
            SMALLER,
            NORMAL,
            LARGEST;

        }
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> timeToLoseEnergy;
        public final ForgeConfigSpec.ConfigValue<Integer> timeToRecoverEnergy;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowToFlyInWater;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowToBreakPlant;
        public final ForgeConfigSpec.ConfigValue<Boolean> allowSpecialRegen;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceToFallWithProjectile;
        public final ForgeConfigSpec.ConfigValue<Boolean> persistantHolidays;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDropPhialOfAnimationInChest;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDropPhialOfAnimationOnBoss;
        public final ForgeConfigSpec.ConfigValue<Integer> chanceDropPumpkinStick;
        public final ForgeConfigSpec.ConfigValue<List<String>> treasureLootTable;

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Theses options can only be modified on the server in multiplayer").push("general");
            this.timeToLoseEnergy = builder.comment("Time to lose an energy point [5..MAX|default:5]").translation(ConfigFlyingThings.getTranslation("time_to_lose_energy")).defineInRange("time_to_lose_energy", 5, 5, Integer.MAX_VALUE);
            this.timeToRecoverEnergy = builder.comment("Time to recover an energy point [5..MAX|default:5]").translation(ConfigFlyingThings.getTranslation("time_to_recover_energy")).defineInRange("timeToRecoverEnergy", 5, 5, Integer.MAX_VALUE);
            this.allowToFlyInWater = builder.comment("Allow flying in water [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_to_fly_in_water")).define("allow_to_fly_in_water", true);
            this.allowToBreakPlant = builder.comment("Allow breaking plants [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_to_break_plant")).define("allow_to_break_plant", true);
            this.allowSpecialRegen = builder.comment("Allow special regeneration [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("allow_special_regen")).define("allow_special_regen", true);
            this.chanceToFallWithProjectile = builder.comment("Chance to fall with projectiles [0..100|default:10]").translation(ConfigFlyingThings.getTranslation("chance_to_fall_with_projectile")).defineInRange("chance_to_fall_with_projectile", 10, 0, 100);
            this.persistantHolidays = builder.comment("Allow special holiday events outside periods [false/true|default:true]").translation(ConfigFlyingThings.getTranslation("persistant_holidays")).define("persistant_holidays", true);
            this.chanceDropPumpkinStick = builder.comment("Chance to get Halloween Sticks during this event [0..1000|default:10]").translation(ConfigFlyingThings.getTranslation("chance_drop_pumpkin_stick")).defineInRange("chance_drop_pumpkin_stick", 10, 0, 1000);
            this.chanceDropPhialOfAnimationInChest = builder.comment("Chance to get a Phial of Animation in chest [0..1000|default:50]").translation(ConfigFlyingThings.getTranslation("chance_drop_phial_of_animation_in_chest")).defineInRange("chance_drop_phial_of_animation_in_chest", 50, 0, 1000);
            this.chanceDropPhialOfAnimationOnBoss = builder.comment("Chance to get a Phial of Animation on boss [0..1000|default:200]").translation(ConfigFlyingThings.getTranslation("chance_drop_phial_of_animation_on_boss")).defineInRange("chance_drop_phial_of_animation_on_boss", 200, 0, 1000);
            this.treasureLootTable = builder.comment("Defines the loottables having a chance to contain a Phial of Animation").translation(ConfigFlyingThings.getTranslation("treasure_loot_table")).define("treasure_loot_table", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"}));
            builder.pop();
        }
    }
}

