/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ModFlyingThings;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.helper.LootHelper;

@Mod.EventBusSubscriber(modid="flying_things", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186387_al)) {
            MinecraftServer server = Helper.getServer();
            if (server == null) {
                ModFlyingThings.LOGGER.warn("A mod called the LootTableLoadEvent from the client side");
            } else {
                server.func_213165_a(() -> LootHelper.addChestEntries(event.getLootTableManager()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBossDrops(LivingDropsEvent event) {
        LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), event.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingFall(LivingFallEvent event) {
        if (Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingInWall(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76368_d && Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        if ((Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get() > 0 && Helper.isRidingFlyingThing(event.getEntity()) && Helper.random.nextFloat() * 100.0f < (float)((Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get()).intValue()) {
            event.getEntity().func_184210_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityAbstractFlyingThing flying_thing;
        if (Helper.isControllingFlyingThing((Entity)event.getEntityLiving()) && (flying_thing = (EntityAbstractFlyingThing)event.getEntityLiving().func_184187_bx()) != null) {
            if (Helper.isValidPlayer((Entity)event.getEntityLiving()) && flying_thing.hasSoulbound()) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)event.getEntityLiving()), (ItemStack)flying_thing.getStack());
            } else {
                event.getEntityLiving().func_70099_a(flying_thing.getStack(), 0.0f);
            }
            flying_thing.func_70106_y();
        }
    }
}

