/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.SliderPercentageOption;
import ovh.corail.flying_things.gui.CustomSelectionButton;

public class ColorButtonHandler {
    private int r;
    private int g;
    private int b;
    private CustomSelectionButton button1;
    private CustomSelectionButton button2;
    private CustomSelectionButton button3;

    ColorButtonHandler(GameSettings settings, List<Widget> list, List<IGuiEventListener> children, int x, int y, int width, int height, int r, int g, int b, String title) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.button1 = new CustomSelectionButton(settings, x, y, width, height, new SliderPercentageOption(title + "_R", 0.0, 255.0, 1.0f, s -> this.r, (s, d) -> {
            this.r = d.intValue();
        }, (s, d) -> title + "_R"), this::getMinColorR, this::getMaxColorR);
        list.add((Widget)this.button1);
        children.add((IGuiEventListener)this.button1);
        this.button2 = new CustomSelectionButton(settings, x, y + 6, width, height, new SliderPercentageOption(title + "_G", 0.0, 255.0, 1.0f, s -> this.g, (s, d) -> {
            this.g = d.intValue();
        }, (s, d) -> title + "_G"), this::getMinColorG, this::getMaxColorG);
        list.add((Widget)this.button2);
        children.add((IGuiEventListener)this.button2);
        this.button3 = new CustomSelectionButton(settings, x, y + 12, width, height, new SliderPercentageOption(title + "_B", 0.0, 255.0, 1.0f, s -> this.b, (s, d) -> {
            this.b = d.intValue();
        }, (s, d) -> title + "_B"), this::getMinColorB, this::getMaxColorB);
        list.add((Widget)this.button3);
        children.add((IGuiEventListener)this.button3);
    }

    private int getMinColorR() {
        return this.g * 256 + this.b;
    }

    private int getMaxColorR() {
        return this.getMinColorR() + 0xFF0000;
    }

    private int getMinColorG() {
        return this.r * 65536 + this.b;
    }

    private int getMaxColorG() {
        return this.getMinColorG() + 65280;
    }

    private int getMinColorB() {
        return this.r * 65536 + this.g * 256;
    }

    private int getMaxColorB() {
        return this.getMinColorB() + 255;
    }

    public int getColor() {
        return 65536 * this.r + 256 * this.g + this.b;
    }
}

