/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.gui.BooleanConfigOption;
import ovh.corail.flying_things.gui.ColorButtonHandler;
import ovh.corail.flying_things.gui.CustomSlider;
import ovh.corail.flying_things.gui.IntegerConfigOption;
import ovh.corail.flying_things.helper.Helper;

public class GuiConfig
extends Screen {
    private int xSize = 200;
    private int ySize = 200;
    private int halfWidth;
    private int guiLeft;
    private int guiTop;
    private int guiRight;
    private final int bgColor = -2144978345;
    private final int textColor = -1;
    private ColorButtonHandler colorHandler1;
    private ColorButtonHandler colorHandler2;

    public GuiConfig(Minecraft mc) {
        super((ITextComponent)new StringTextComponent("The Flying Things Config"));
        this.minecraft = mc;
    }

    public GuiConfig(Minecraft minecraft, Screen parentScreen) {
        this(minecraft);
    }

    public void init() {
        this.halfWidth = this.width / 2;
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.guiRight = this.guiLeft + this.xSize;
        this.buttons.clear();
        int sliderX = this.guiRight - 60;
        this.addButton((Widget)new CustomSlider(this.getMinecraft().field_71474_y, sliderX, this.guiTop + 57, 50, 20, new SliderPercentageOption("bar_pos_y", 0.0, 100.0, 1.0f, settings -> (double)((Integer)ConfigFlyingThings.client.barHeightPos.get()), (settings, d) -> ConfigFlyingThings.client.barHeightPos.set((Object)d.intValue()), (settings, slider) -> MathHelper.func_76128_c((double)slider.func_216729_a(settings)) + "%")));
        this.addButton(new BooleanConfigOption("Render Effect", () -> ConfigFlyingThings.client.renderEffect.get(), arg_0 -> ConfigFlyingThings.client.renderEffect.set(arg_0)).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 80, this.xSize));
        this.addButton(new BooleanConfigOption("Display Bar Values", () -> ConfigFlyingThings.client.barValue.get(), arg_0 -> ConfigFlyingThings.client.barValue.set(arg_0)).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 100, this.xSize));
        int[] colors = Helper.getRGBColor3I((Integer)ConfigFlyingThings.client.barColorEnergy.get());
        this.colorHandler1 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.halfWidth + 10, this.guiTop + 120, 80, 4, colors[0], colors[1], colors[2], "energy_bar_color");
        colors = Helper.getRGBColor3I((Integer)ConfigFlyingThings.client.barColorSpeed.get());
        this.colorHandler2 = new ColorButtonHandler(this.getMinecraft().field_71474_y, this.buttons, this.children, this.halfWidth + 10, this.guiTop + 140, 80, 4, colors[0], colors[1], colors[2], "speed_bar_color");
        this.addButton(new IntegerConfigOption("Energy Bar Graduation", () -> ((ConfigFlyingThings.Client.Graduation)((Object)((Object)ConfigFlyingThings.client.barGraduationEnergy.get()))).ordinal(), i -> ConfigFlyingThings.client.barGraduationEnergy.set((Object)ConfigFlyingThings.Client.Graduation.values()[i]), ConfigFlyingThings.Client.Graduation.values().length - 1, i -> "Energy Bar Graduation : " + ConfigFlyingThings.Client.Graduation.values()[i].name()).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 160, 190));
        this.addButton(new IntegerConfigOption("Speed Bar Graduation", () -> ((ConfigFlyingThings.Client.Graduation)((Object)((Object)ConfigFlyingThings.client.barGraduationSpeed.get()))).ordinal(), i -> ConfigFlyingThings.client.barGraduationSpeed.set((Object)ConfigFlyingThings.Client.Graduation.values()[i]), ConfigFlyingThings.Client.Graduation.values().length - 1, i -> "Speed Bar Graduation : " + ConfigFlyingThings.Client.Graduation.values()[i].name()).func_216586_a(this.getMinecraft().field_71474_y, this.guiLeft + 3, this.guiTop + 180, 190));
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void onClose() {
        int color2;
        int color1 = this.colorHandler1.getColor();
        if (color1 != (Integer)ConfigFlyingThings.client.barColorEnergy.get()) {
            ConfigFlyingThings.client.barColorEnergy.set((Object)color1);
        }
        if ((color2 = this.colorHandler2.getColor()) != (Integer)ConfigFlyingThings.client.barColorSpeed.get()) {
            ConfigFlyingThings.client.barColorSpeed.set((Object)color2);
        }
        super.onClose();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.font.getClass();
        GuiConfig.fill((int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiRight - 5), (int)(this.guiTop + 20 + 9), (int)this.bgColor);
        this.drawStringAt(this.title.func_150254_d(), 14, this.textColor, true);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStringAt("Bar Pos Y (in %)", 65);
        this.drawStringAt("Speed Bar Color", 125, this.colorHandler1.getColor(), false);
        this.drawStringAt("Energy Bar Color", 145, this.colorHandler2.getColor(), false);
        super.render(mouseX, mouseY, partialTicks);
    }

    private void drawStringAt(String text, int y) {
        this.drawStringAt(text, y, this.textColor, false);
    }

    private void drawStringAt(String text, int y, int textColor, boolean centered) {
        this.drawString(this.font, text, centered ? this.halfWidth - this.font.func_78256_a(text) / 2 : this.guiLeft + 10, this.guiTop + y, textColor);
    }

    public void renderBackground() {
        super.renderBackground();
        GuiConfig.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)Integer.MIN_VALUE);
        GuiConfig.fill((int)(this.guiLeft - 3), (int)(this.guiTop - 3), (int)(this.guiLeft + this.xSize + 3), (int)(this.guiTop + this.ySize + 3), (int)this.bgColor);
    }
}

