/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.helper.TextureLocation;

@OnlyIn(value=Dist.CLIENT)
public class GuiOverlayEnergy
extends Screen {
    public final int width;
    public final int height;
    public final int guiLeft;
    public final int barLength;

    public GuiOverlayEnergy(Minecraft mc) {
        super((ITextComponent)new StringTextComponent("Flying Things Energy"));
        this.minecraft = mc;
        this.width = mc.func_228018_at_().func_198107_o();
        this.height = mc.func_228018_at_().func_198087_p();
        this.barLength = 182;
        this.guiLeft = (this.width - this.barLength) / 2;
        this.drawScreen();
    }

    private void drawScreen() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (Helper.isRidingFlyingThing((Entity)player)) {
            EntityAbstractFlyingThing mount = (EntityAbstractFlyingThing)player.func_184187_bx();
            assert (mount != null);
            GuiOverlayEnergy.drawBars(this, this.guiLeft, this.height * (Integer)ConfigFlyingThings.client.barHeightPos.get() / 100, this.barLength, mount.getEnergy(), mount.speed);
        }
    }

    static void drawBars(Screen screen, int guiLeft, int guiTop, int barWidth, int energy, double mountSpeed) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.enableBlend();
        mc.func_110434_K().func_110577_a(TextureLocation.BARS);
        int colorPosY = 60;
        int filled = (int)((double)(energy * barWidth) / (double)((Integer)ConfigFlyingThings.shared_datas.maxEnergy.get()).intValue()) + 1;
        float[] colors = Helper.getRGBColor3F((Integer)ConfigFlyingThings.client.barColorEnergy.get());
        RenderSystem.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)0.5f);
        screen.blit(guiLeft, guiTop, 0, colorPosY, barWidth, 5);
        if (filled > 0) {
            RenderSystem.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
            screen.blit(guiLeft, guiTop, 0, colorPosY + 5, filled, 5);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.blit(guiLeft, guiTop, 0, ((ConfigFlyingThings.Client.Graduation)((Object)ConfigFlyingThings.client.barGraduationEnergy.get())).ordinal() * 10 + 80, barWidth, 5);
        float speed = (float)mountSpeed * 100.0f;
        float speedMax = ((Integer)ConfigFlyingThings.shared_datas.speedMax.get()).intValue();
        filled = mountSpeed >= (double)speedMax ? barWidth + 1 : (int)(speed * (float)barWidth / speedMax) + 1;
        colors = Helper.getRGBColor3F((Integer)ConfigFlyingThings.client.barColorSpeed.get());
        RenderSystem.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)0.5f);
        screen.blit(guiLeft, guiTop + 7, 0, colorPosY, barWidth, 5);
        if (filled > 0) {
            RenderSystem.color4f((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
            screen.blit(guiLeft, guiTop + 7, 0, colorPosY + 5, filled, 5);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.blit(guiLeft, guiTop + 7, 0, ((ConfigFlyingThings.Client.Graduation)((Object)ConfigFlyingThings.client.barGraduationSpeed.get())).ordinal() * 10 + 80, barWidth, 5);
        if (((Boolean)ConfigFlyingThings.client.barValue.get()).booleanValue()) {
            GuiOverlayEnergy.fill((int)guiLeft, (int)(guiTop + 14), (int)(guiLeft + 130), (int)(guiTop + 40), (int)0x20000000);
            screen.drawString(mc.field_71466_p, "Speed : " + MathHelper.func_76128_c((double)Math.min(mountSpeed * 100.0, (double)((Integer)ConfigFlyingThings.shared_datas.speedMax.get()).intValue())) + " / " + ConfigFlyingThings.shared_datas.speedMax.get(), guiLeft + 10, guiTop + 18, -1593835521);
            screen.drawString(mc.field_71466_p, "Energy : " + energy + " / " + ConfigFlyingThings.shared_datas.maxEnergy.get(), guiLeft + 10, guiTop + 28, -1593835521);
        }
        RenderSystem.defaultBlendFunc();
    }
}

