/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IntegerConfigOption
extends AbstractOption {
    private final IntSupplier supplier;
    private final Consumer<Integer> consumer;
    private int max;
    private Function<Integer, String> functionName;

    IntegerConfigOption(String title, IntSupplier supplier, Consumer<Integer> consumer, int max, Function<Integer, String> functionName) {
        super(title);
        this.supplier = supplier;
        this.consumer = consumer;
        this.max = max;
        this.functionName = functionName;
    }

    private void set(int value) {
        this.consumer.accept(value);
    }

    public int get() {
        return this.supplier.getAsInt();
    }

    public Widget func_216586_a(GameSettings options, int x, int y, int width) {
        return new OptionButton(x, y, width, 14, this, this.getOptionName(), pressable -> {
            this.set(this.supplier.getAsInt() >= this.max ? 0 : this.supplier.getAsInt() + 1);
            pressable.setMessage(this.getOptionName());
        }){

            public void renderButton(int mouseX, int mouseY, float partialTicks) {
                Minecraft minecraft = Minecraft.func_71410_x();
                this.renderBg(minecraft, mouseX, mouseY);
                int j = this.isHovered() ? -7769547 : -1;
                this.drawCenteredString(minecraft.field_71466_p, this.getMessage(), this.x + this.width / 2, this.y + (this.height - 8) / 2, j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
            }
        };
    }

    private String getOptionName() {
        return this.functionName.apply(this.get());
    }
}

