/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.registry.ModEntities;

public class Helper {
    @Nullable
    private static Boolean isHalloween = null;
    public static final Random random = new Random();

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity;
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return Helper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isFlyingthing(@Nullable Entity entity) {
        return entity != null && (entity.func_200600_R() == ModEntities.enchanted_broom || entity.func_200600_R() == ModEntities.magic_carpet);
    }

    public static boolean isBoss(@Nullable Entity entity) {
        return entity != null && !entity.func_184222_aU();
    }

    public static boolean isRidingFlyingThing(@Nullable Entity entity) {
        return entity != null && Helper.isFlyingthing(entity.func_184187_bx());
    }

    public static boolean isControllingFlyingThing(@Nullable Entity entity) {
        return Helper.isRidingFlyingThing(entity) && entity.func_184187_bx().func_184179_bs() == entity;
    }

    public static String getDimensionString(DimensionType dimensionType) {
        ResourceLocation rl = DimensionType.func_212678_a((DimensionType)dimensionType);
        return rl == null ? "" : rl.toString();
    }

    public static boolean isDateAroundHalloween() {
        if (((Boolean)ConfigFlyingThings.general.persistantHolidays.get()).booleanValue()) {
            return true;
        }
        if (isHalloween == null) {
            LocalDate date = LocalDate.now();
            isHalloween = date.get(ChronoField.MONTH_OF_YEAR) + 1 == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) + 1 == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3;
        }
        return isHalloween;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getNameForKeybindSneak() {
        return Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_197978_k();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeClientPotionEffect(Effect effect) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_184596_c(effect);
        }
    }

    @Nullable
    public static MinecraftServer getServer() {
        try {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            if (server != null && server.func_213162_bc()) {
                return server;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPacketToClient(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.SERVER && ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT;
    }

    public static boolean isPacketToServer(NetworkEvent.Context ctx) {
        return ctx.getDirection().getOriginationSide() == LogicalSide.CLIENT && ctx.getDirection().getReceptionSide() == LogicalSide.SERVER;
    }

    public static float[] getRGBColor4F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static int[] getRGBColor3I(int color) {
        int[] rgb = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return rgb;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int color1, int color2, int zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor4F(color1);
        float[] argb2 = Helper.getRGBColor4F(color2);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Helper.makeVertex(bufferbuilder, right, top, zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(bufferbuilder, left, top, zLevel, argb1);
        Helper.makeVertex(bufferbuilder, left, bottom, zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(bufferbuilder, right, bottom, zLevel, argb2);
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)zLevel).func_227885_a_(colorArray[0], colorArray[1], colorArray[2], colorArray[3]).func_181675_d();
    }
}

