/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.helper;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.registry.ModItems;

public class LootHelper {
    private static final Field fieldIsFrozen = ObfuscationReflectionHelper.findField(LootTable.class, (String)"isFrozen");

    public static void addChestEntries(LootTableManager manager) {
        int weight = (Integer)ConfigFlyingThings.general.chanceDropPhialOfAnimationInChest.get();
        if (weight == 0) {
            return;
        }
        LootPool.Builder builder = new LootPool.Builder().name("flying_things:chest_treasure");
        builder.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.phialOfAnimation).func_216085_b(2).func_216086_a(weight));
        builder.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(1000 - weight));
        LootPool chestTreasure = builder.func_216044_b();
        for (String targetTableString : (List)ConfigFlyingThings.general.treasureLootTable.get()) {
            LootTable targetTable = manager.func_186521_a(new ResourceLocation(targetTableString));
            if (targetTable == LootTable.field_186464_a) continue;
            try {
                fieldIsFrozen.set(targetTable, false);
                targetTable.addPool(chestTreasure);
                fieldIsFrozen.set(targetTable, true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, @Nullable DamageSource damageSource) {
        if (Helper.isBoss((Entity)entity)) {
            if (Helper.random.nextFloat() * 1000.0f <= (float)((Integer)ConfigFlyingThings.general.chanceDropPhialOfAnimationOnBoss.get()).intValue()) {
                drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ModItems.phialOfAnimation)));
            }
        } else if (entity instanceof MonsterEntity && Helper.isDateAroundHalloween() && damageSource != null && damageSource.func_76346_g() instanceof PlayerEntity && Helper.random.nextFloat() * 1000.0f <= (float)((Integer)ConfigFlyingThings.general.chanceDropPumpkinStick.get()).intValue()) {
            drops.add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ModItems.pumpkinStick)));
        }
    }
}

