/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.registry.ModEntities;
import ovh.corail.flying_things.render.TEISRMagicCarpet;

public class ItemMagicCarpet
extends ItemAbstractFlyingThing {
    private static final int MAX_ID = 19;

    public ItemMagicCarpet() {
        super("magic_carpet", ItemMagicCarpet.getBuilder(true).func_200917_a(1).setISTER(() -> TEISRMagicCarpet::new));
    }

    @Override
    EntityType<?> getEntityType() {
        return ModEntities.magic_carpet;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i <= 19; ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemMagicCarpet.setModelType(stack, i);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public boolean canFlyInDimension(DimensionType dimensionType) {
        return !((List)ConfigFlyingThings.deniedDimensionToFly.deniedDimensionCarpet.get()).contains(Helper.getDimensionString(dimensionType));
    }

    @Override
    public int getActualRegen(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        boolean hasSpecialRegen = (Boolean)ConfigFlyingThings.general.allowSpecialRegen.get() != false && world.func_175667_e(entity.func_180425_c().func_177977_b()) && world.func_180495_p(entity.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150425_aM;
        return hasSpecialRegen ? 20 : 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        ClientPlayerEntity player;
        if (!Screen.hasShiftDown()) {
            list.add(new TranslationTextComponent("flying_things.message.hold_key", new Object[]{"SHIFT"}).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("flying_things.message.for_more_infos", new Object[0])));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("flying_things.item.magic_carpet.desc1", new Object[0]));
            list.add((ITextComponent)new TranslationTextComponent("flying_things.item.magic_carpet.desc2", new Object[]{Helper.getNameForKeybindSneak()}));
        }
        int id = ItemMagicCarpet.getModelType(stack);
        if (!(id != 18 && id != 19 || (player = Minecraft.func_71410_x().field_71439_g) == null || player.func_70644_a(Effects.field_220310_F))) {
            list.add((ITextComponent)new TranslationTextComponent("flying_things.message.require_effect", new Object[]{new StringTextComponent("[").func_150257_a((ITextComponent)new TranslationTextComponent(Effects.field_220310_F.func_76393_a(), new Object[0])).func_150258_a("]")}));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        int modelType = ItemMagicCarpet.getModelType(stack);
        String postName = "";
        if (modelType == 18 || modelType == 19) {
            postName = ".pillage";
        } else if (modelType > 8 && modelType < 14) {
            postName = ".halloween";
        }
        return new TranslationTextComponent(this.func_77667_c(stack) + postName, new Object[0]);
    }

    @Override
    void onEntitySpawn(ItemStack stack, EntityAbstractFlyingThing entity) {
    }
}

