/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.helper.Helper;

public class UpdateConfigMessage {
    private boolean allowTombstoneSoulbound;
    private int[] intConfigs;

    public UpdateConfigMessage(boolean allowTombstoneSoulbound, int[] intConfigs) {
        this.allowTombstoneSoulbound = allowTombstoneSoulbound;
        this.intConfigs = intConfigs;
    }

    static UpdateConfigMessage fromBytes(PacketBuffer buf) {
        return new UpdateConfigMessage(buf.readBoolean(), buf.func_186863_b());
    }

    static void toBytes(UpdateConfigMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.allowTombstoneSoulbound);
        buf.func_186875_a(msg.intConfigs);
    }

    public static class Handler {
        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ConfigFlyingThings.updateConfig(message.allowTombstoneSoulbound, message.intConfigs));
            }
            ctx.setPacketHandled(true);
        }
    }
}

