/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.entity.EntityEnchantedBroom;
import ovh.corail.flying_things.helper.Functions;
import ovh.corail.flying_things.helper.TextureLocation;
import ovh.corail.flying_things.model.ModelEnchantedBroom;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnchantedBroom
extends EntityRenderer<EntityEnchantedBroom> {
    private static final ModelEnchantedBroom model = new ModelEnchantedBroom();

    public RenderEnchantedBroom(EntityRendererManager renderManager) {
        super(renderManager);
        this.field_76987_f = 0.2f;
        this.field_76989_e = 0.2f;
    }

    public void render(EntityEnchantedBroom entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int light) {
        RenderEnchantedBroom.render(entity, entityYaw, entity.field_70173_aa, partialTicks, matrixStack, iRenderTypeBuffer, light, false);
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, iRenderTypeBuffer, light);
    }

    public ResourceLocation getEntityTexture(EntityEnchantedBroom entity) {
        return RenderEnchantedBroom.getTexture(entity);
    }

    private static ResourceLocation getTexture(EntityEnchantedBroom entity) {
        return TextureLocation.TEXTURE_CONCRETE[entity.getModelType() < TextureLocation.TEXTURE_CONCRETE.length ? entity.getModelType() : 12];
    }

    public boolean shouldRender(EntityEnchantedBroom entity, ClippingHelperImpl camera, double camX, double camY, double camZ) {
        return entity.field_70170_p == null || super.func_225626_a_((Entity)entity, camera, camX, camY, camZ);
    }

    public static void render(EntityEnchantedBroom entity, float entityYaw, int ticksExisted, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int packedLight, boolean isTEISR) {
        matrixStack.func_227860_a_();
        if (!isTEISR) {
            matrixStack.func_227861_a_(0.0, 0.2, 0.0);
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        if (!isTEISR) {
            float f = (float)entity.getTimeSinceHit() - partialTicks;
            float f1 = entity.getDamageTaken() - partialTicks;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.getForwardDirection()));
            }
        }
        model.func_225598_a_(matrixStack, Functions.VERTEX_BUILDER_CUTOUT.apply(iRenderTypeBuffer, RenderEnchantedBroom.getTexture(entity)), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.getHeadType() > 0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            RenderEnchantedBroom.model.head.func_228309_a_(matrixStack, Functions.VERTEX_BUILDER_CUTOUT.apply(iRenderTypeBuffer, TextureLocation.TEXTURE_SKULL[entity.getHeadType() - 1]), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

