/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.config.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityMagicCarpet;
import ovh.corail.flying_things.helper.Functions;
import ovh.corail.flying_things.helper.TextureLocation;

@OnlyIn(value=Dist.CLIENT)
public final class RenderMagicCarpet
extends EntityRenderer<EntityMagicCarpet> {
    private static final float TOP_MIN_U = 0.0f;
    private static final float TOP_MIN_V = 0.0f;
    private static final float TOP_MAX_U = 1.0f;
    private static final float TOP_MAX_V = 1.0f;
    private static final float BOTTOM_MIN_U = 0.0f;
    private static final float BOTTOM_MIN_V = 0.0f;
    private static final float BOTTOM_MAX_U = 1.0f;
    private static final float BOTTOM_MAX_V = 1.0f;
    private static final int FACE_COUNT = 16;
    private static final int VERTEX_COUNT = 17;
    private static final float WIDTH = 1.4f;
    private static final float LENGTH = 2.1f;
    private static final float X1 = 0.7f;
    private static final float X0 = -0.7f;
    private static final float[] VERT_Y = new float[17];
    private static final float[] VERT_Z = new float[17];

    public RenderMagicCarpet(EntityRendererManager manager) {
        super(manager);
        this.field_76987_f = 0.2f;
        this.field_76989_e = 0.2f;
    }

    public void render(EntityMagicCarpet entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int packedLight) {
        RenderMagicCarpet.render(entity, entityYaw, entity.field_70173_aa, partialTicks, matrixStack, iRenderTypeBuffer, packedLight, false);
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, iRenderTypeBuffer, packedLight);
    }

    public ResourceLocation getEntityTexture(EntityMagicCarpet entity) {
        return RenderMagicCarpet.getTexture(entity);
    }

    private static ResourceLocation getTexture(EntityMagicCarpet entity) {
        return TextureLocation.TEXTURE_CARPET[entity.getModelType() < TextureLocation.TEXTURE_CARPET.length ? entity.getModelType() : 0];
    }

    public boolean shouldRender(EntityMagicCarpet entity, ClippingHelperImpl camera, double camX, double camY, double camZ) {
        return entity.field_70170_p == null || super.func_225626_a_((Entity)entity, camera, camX, camY, camZ);
    }

    public static void render(EntityMagicCarpet entity, float entityYaw, int ticksExisted, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int packedLight, boolean isTEISR) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)-0.7f, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        if (!isTEISR) {
            float f = (float)entity.getTimeSinceHit() - partialTicks;
            float f1 = entity.getDamageTaken() - partialTicks;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.getForwardDirection()));
            }
        }
        float ageInTicks = (float)ticksExisted + partialTicks;
        for (int i = 0; i < 17; ++i) {
            RenderMagicCarpet.VERT_Y[i] = MathHelper.func_76126_a((float)(ageInTicks * 0.1f + (float)i * 0.25f)) * 0.065f + 0.95f;
            RenderMagicCarpet.VERT_Z[i] = (float)i / 16.0f * 2.1f - 1.05f;
        }
        RenderMagicCarpet.drawCarpet(matrixStack, Functions.VERTEX_BUILDER_CUTOUT.apply(iRenderTypeBuffer, RenderMagicCarpet.getTexture(entity)), packedLight);
        if (((Boolean)ConfigFlyingThings.client.renderEffect.get()).booleanValue()) {
            RenderMagicCarpet.drawCarpet(matrixStack, Functions.VERTEX_BUILDER_GLINT.apply(iRenderTypeBuffer), packedLight);
        }
        matrixStack.func_227865_b_();
    }

    private static void drawCarpet(MatrixStack matrixStack, IVertexBuilder buf, int packedLight) {
        MatrixStack.Entry last = matrixStack.func_227866_c_();
        Matrix4f matrix4f = last.func_227870_a_();
        Matrix3f matrixNormal = last.func_227872_b_();
        for (int i = 0; i < 16; ++i) {
            float t0 = (float)i / 16.0f;
            float t1 = (float)(i + 1) / 16.0f;
            float y0 = VERT_Y[i];
            float y1 = VERT_Y[i + 1];
            float z0 = VERT_Z[i];
            float z1 = VERT_Z[i + 1];
            float v00 = 0.0f + 1.0f * t0;
            float v01 = 0.0f + 1.0f * t1;
            buf.func_227888_a_(matrix4f, -0.7f, y0, z0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, v00).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, -0.7f, y1, z1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, v01).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, 0.7f, y1, z1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, v01).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, 0.7f, y0, z0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, v00).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
            float v10 = 0.0f + 1.0f * t0;
            float v11 = 0.0f + 1.0f * t1;
            buf.func_227888_a_(matrix4f, -0.7f, y1, z1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, v11).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, -0.7f, y0, z0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, v10).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, 0.7f, y0, z0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, v10).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(matrix4f, 0.7f, y1, z1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, v11).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrixNormal, 0.0f, -1.0f, 0.0f).func_181675_d();
        }
    }
}

