/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class PatchGen
implements IWorldGenerator {
    private int timeSinceLastPatch = 0;
    private final int timeToWaitBeforeBonusPatch = FragileGlassBase.genChance + 1;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase b = world.func_72807_a(chunkX, chunkZ);
        if (b.func_76746_c()) {
            this.timeSinceLastPatch = random.nextInt(FragileGlassBase.genChance) == 0 && this.genPatch(random, chunkX, chunkZ, world) ? 0 : (this.timeSinceLastPatch >= this.timeToWaitBeforeBonusPatch && this.genPatch(random, chunkX, chunkZ, world) ? 0 : ++this.timeSinceLastPatch);
        }
    }

    private boolean genPatch(Random random, int chunkX, int chunkZ, World world) {
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        int nextChunkBlockX = chunkBlockX + 16;
        int nextChunkBlockZ = chunkBlockZ + 16;
        for (int candX = chunkBlockX; candX < nextChunkBlockX; candX += 8) {
            for (int candZ = chunkBlockZ; candZ < nextChunkBlockZ; candZ += 8) {
                int patchRadius;
                int patchY = world.func_72825_h(candX, candZ) - 1;
                Block candidate = world.func_147439_a(candX, patchY, candZ);
                if (!(candidate instanceof BlockIce) && !FragileGlassBase.iceBlocks.contains(Item.func_150898_a((Block)candidate))) continue;
                for (int rad = patchRadius = (int)((2.0 * random.nextGaussian() + (double)FragileGlassBase.avePatchSize) / 2.0); rad > 0; --rad) {
                    for (double d = 0.0; d < 360.0; d += 10.0) {
                        int nextZ;
                        double r = Math.toRadians(d);
                        int nextX = (int)((double)candX + (double)rad * Math.cos(r));
                        Block nextBlock = world.func_147439_a(nextX, patchY, nextZ = (int)((double)candZ + (double)rad * Math.sin(r)));
                        if (!(nextBlock instanceof BlockIce) && !FragileGlassBase.iceBlocks.contains(Item.func_150898_a((Block)nextBlock))) continue;
                        if (rad > patchRadius - 2) {
                            if (!random.nextBoolean()) continue;
                            world.func_147449_b(nextX, patchY, nextZ, FragileGlassBase.thinIce);
                            continue;
                        }
                        world.func_147449_b(nextX, patchY, nextZ, FragileGlassBase.thinIce);
                    }
                }
                world.func_147449_b(candX, patchY, candZ, FragileGlassBase.thinIce);
                return true;
            }
        }
        return false;
    }
}

