/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class PatchGen
implements IWorldGenerator {
    private int timeSinceLastPatch = 0;
    private final int timeToWaitBeforeBonusPatch = FragileGlassBase.genChance + 1;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase b = world.func_180494_b(new BlockPos(chunkX, 62, chunkZ));
        if (b.func_76746_c()) {
            if (random.nextInt(FragileGlassBase.genChance) == 0) {
                this.genPatch(random, chunkX, chunkZ, world);
                this.timeSinceLastPatch = 0;
            } else if (this.timeSinceLastPatch == this.timeToWaitBeforeBonusPatch) {
                this.genPatch(random, chunkX, chunkZ, world);
                this.timeSinceLastPatch = 0;
            } else {
                ++this.timeSinceLastPatch;
            }
        }
    }

    public void genPatch(Random random, int chunkX, int chunkZ, World world) {
        int patchRad;
        int midX = chunkX * 16 + random.nextInt(16);
        int midZ = chunkZ * 16 + random.nextInt(16);
        int y = 62;
        for (int rad = patchRad = (int)((2.0 * random.nextGaussian() + (double)FragileGlassBase.avePatchSize) / 2.0); rad > 0; --rad) {
            for (double t = 0.0; t < 360.0; t += 10.0) {
                BlockPos currentPos = new BlockPos((int)((double)midX + (double)rad * Math.cos(t)), y, (int)((double)midZ + (double)rad * Math.sin(t)));
                if (world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150432_aD) continue;
                if (rad > patchRad - 2) {
                    if (!random.nextBoolean()) continue;
                    world.func_175656_a(currentPos, FragileGlassBase.thinIce.func_176223_P());
                    continue;
                }
                world.func_175656_a(currentPos, FragileGlassBase.thinIce.func_176223_P());
            }
        }
    }
}

