/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.block.BlockFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockFragilePane;
import com.fredtargaryen.fragileglass.block.BlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockStainedFragilePane;
import com.fredtargaryen.fragileglass.block.BlockSugarCauldron;
import com.fredtargaryen.fragileglass.block.BlockThinIce;
import com.fredtargaryen.fragileglass.block.BlockWeakStone;
import com.fredtargaryen.fragileglass.block.SugarBlock;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapFactory;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapStorage;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.IPlayerBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakFactory;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakStorage;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragilePane;
import com.fredtargaryen.fragileglass.network.MessageBreakerMovement;
import com.fredtargaryen.fragileglass.network.PacketHandler;
import com.fredtargaryen.fragileglass.proxy.CommonProxy;
import com.fredtargaryen.fragileglass.tileentity.TileEntityFragile;
import com.fredtargaryen.fragileglass.tileentity.TileEntityFragileGlass;
import com.fredtargaryen.fragileglass.tileentity.TileEntityThinIce;
import com.fredtargaryen.fragileglass.tileentity.TileEntityWeakStone;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapFactory;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapStorage;
import com.fredtargaryen.fragileglass.tileentity.capability.IFragileCapability;
import com.fredtargaryen.fragileglass.world.BreakSystem;
import com.fredtargaryen.fragileglass.worldgen.PatchGen;
import com.fredtargaryen.fragileglass.worldgen.PatchGenIce;
import com.fredtargaryen.fragileglass.worldgen.PatchGenStone;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="ftfragileglass", version="1.8.6", name="Fragile Glass and Thin Ice", acceptedMinecraftVersions="[1.11.2]")
public class FragileGlassBase {
    @Mod.Instance(value="ftfragileglass")
    public static FragileGlassBase instance;
    public static ArrayList<Item> iceBlocks;
    public static boolean genThinIce;
    public static int avePatchSizeIce;
    public static int genChanceIce;
    private static boolean genWeakStone;
    public static int avePatchSizeStone;
    public static int genChanceStone;
    public static PatchGen patchGenIce;
    public static PatchGen patchGenStone;
    public static BreakSystem breakSystem;
    public static Block fragileGlass;
    public static Block fragilePane;
    public static Block stainedFragileGlass;
    public static Block stainedFragilePane;
    public static Block sugarBlock;
    public static Block thinIce;
    public static Block sugarCauldron;
    public static Block weakStone;
    public static Item iFragileGlass;
    public static Item iFragilePane;
    public static Item iStainedFragileGlass;
    public static Item iStainedFragilePane;
    public static Item iSugarBlock;
    public static Item iThinIce;
    public static Item iSugarCauldron;
    public static Item iWeakStone;
    @SidedProxy(clientSide="com.fredtargaryen.fragileglass.proxy.ClientProxy", serverSide="com.fredtargaryen.fragileglass.proxy.ServerProxy")
    public static CommonProxy proxy;
    @CapabilityInject(value=IBreakCapability.class)
    public static Capability<IBreakCapability> BREAKCAP;
    @CapabilityInject(value=IPlayerBreakCapability.class)
    public static Capability<IPlayerBreakCapability> PLAYERBREAKCAP;
    @CapabilityInject(value=IFragileCapability.class)
    public static Capability<IFragileCapability> FRAGILECAP;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(IBreakCapability.class, (Capability.IStorage)new BreakCapStorage(), (Callable)new BreakCapFactory());
        CapabilityManager.INSTANCE.register(IPlayerBreakCapability.class, (Capability.IStorage)new PlayerBreakStorage(), (Callable)new PlayerBreakFactory());
        CapabilityManager.INSTANCE.register(IFragileCapability.class, (Capability.IStorage)new FragileCapStorage(), (Callable)new FragileCapFactory());
        MinecraftForge.EVENT_BUS.register((Object)this);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        genThinIce = config.getBoolean("genThinIce", "Worldgen - Thin Ice", true, "If true, thin ice patches will generate on frozen bodies of water");
        avePatchSizeIce = config.getInt("avePatchSizeIce", "Worldgen - Thin Ice", 5, 1, 14, "Average patch diameter");
        genChanceIce = config.getInt("genChanceIce", "Worldgen - Thin Ice", 3, 1, 5, "1 in x chance of patch appearing");
        genWeakStone = config.getBoolean("genWeakStone", "Worldgen - Weak Stone", false, "If true, weak stone patches will generate. Expect falls into lava!");
        avePatchSizeStone = config.getInt("avePatchSizeStone", "Worldgen - Weak Stone", 5, 1, 14, "Average patch diameter");
        genChanceStone = config.getInt("genChanceStone", "Worldgen - Weak Stone", 3, 1, 5, "1 in x chance of patch appearing");
        config.save();
        fragileGlass = (Block)new BlockFragileGlass().func_149663_c("ftfragileglass").setRegistryName("ftfragileglass");
        fragilePane = (Block)new BlockFragilePane().func_149663_c("ftfragilepane").setRegistryName("ftfragilepane");
        stainedFragileGlass = (Block)new BlockStainedFragileGlass().func_149663_c("ftstainedfragileglass").setRegistryName("ftstainedfragileglass");
        stainedFragilePane = (Block)new BlockStainedFragilePane().func_149663_c("ftstainedfragilepane").setRegistryName("ftstainedfragilepane");
        sugarBlock = (Block)new SugarBlock().func_149663_c("ftsugarblock").setRegistryName("ftsugarblock");
        thinIce = (Block)new BlockThinIce().func_149663_c("ftthinice").setRegistryName("ftthinice");
        sugarCauldron = (Block)new BlockSugarCauldron().func_149663_c("ftsugarcauldron").func_149711_c(5.0f).func_149752_b(10.0f).setRegistryName("ftsugarcauldron");
        weakStone = (Block)new BlockWeakStone().func_149663_c("ftweakstone").setRegistryName("ftweakstone");
        iFragileGlass = (Item)new ItemBlock(fragileGlass).setRegistryName("ftfragileglass");
        iFragilePane = (Item)new ItemBlock(fragilePane).setRegistryName("ftfragilepane");
        iStainedFragileGlass = (Item)new ItemBlockStainedFragileGlass(stainedFragileGlass).setRegistryName("ftstainedfragileglass");
        iStainedFragilePane = (Item)new ItemBlockStainedFragilePane(stainedFragilePane).setRegistryName("ftstainedfragilepane");
        iSugarBlock = (Item)new ItemBlock(sugarBlock).setRegistryName("ftsugarblock");
        iThinIce = (Item)new ItemBlock(thinIce).setRegistryName("ftthinice");
        iSugarCauldron = (Item)new ItemBlock(sugarCauldron).setRegistryName("ftsugarcauldron");
        iWeakStone = (Item)new ItemBlock(weakStone).setRegistryName("ftweakstone");
        GameRegistry.register((IForgeRegistryEntry)fragileGlass);
        GameRegistry.register((IForgeRegistryEntry)iFragileGlass);
        GameRegistry.register((IForgeRegistryEntry)fragilePane);
        GameRegistry.register((IForgeRegistryEntry)iFragilePane);
        GameRegistry.register((IForgeRegistryEntry)stainedFragileGlass);
        GameRegistry.register((IForgeRegistryEntry)iStainedFragileGlass);
        GameRegistry.register((IForgeRegistryEntry)stainedFragilePane);
        GameRegistry.register((IForgeRegistryEntry)iStainedFragilePane);
        GameRegistry.register((IForgeRegistryEntry)sugarBlock);
        GameRegistry.register((IForgeRegistryEntry)iSugarBlock);
        GameRegistry.register((IForgeRegistryEntry)thinIce);
        GameRegistry.register((IForgeRegistryEntry)iThinIce);
        GameRegistry.register((IForgeRegistryEntry)sugarCauldron);
        GameRegistry.register((IForgeRegistryEntry)iSugarCauldron);
        GameRegistry.register((IForgeRegistryEntry)weakStone);
        GameRegistry.register((IForgeRegistryEntry)iWeakStone);
        OreDictionary.registerOre((String)"blockSugar", (Block)sugarBlock);
        proxy.registerModels();
        proxy.doStateMappings();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack(sugarBlock, 1), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Items.field_151102_aT});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151102_aT, 9), (Object[])new Object[]{new ItemStack(sugarBlock)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sugarCauldron), (Object[])new Object[]{Items.field_151102_aT, Items.field_151066_bu});
        GameRegistry.addRecipe((ItemStack)new ItemStack(fragilePane, 16), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), fragileGlass});
        GameRegistry.addRecipe((ItemStack)new ItemStack(weakStone, 2), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), Blocks.field_150333_U});
        for (int meta = 0; meta < 16; ++meta) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(stainedFragileGlass, 8, meta), (Object[])new Object[]{"xxx", "xox", "xxx", Character.valueOf('x'), new ItemStack(fragileGlass), Character.valueOf('o'), new ItemStack(Items.field_151100_aR, 1, 15 - meta)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(stainedFragilePane, 16, meta), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), new ItemStack(stainedFragileGlass, 1, meta)});
        }
        GameRegistry.registerTileEntity(TileEntityFragileGlass.class, (String)"TEFG");
        GameRegistry.registerTileEntity(TileEntityThinIce.class, (String)"TETI");
        GameRegistry.registerTileEntity(TileEntityWeakStone.class, (String)"TEWS");
        if (genThinIce) {
            patchGenIce = new PatchGenIce();
            GameRegistry.registerWorldGenerator((IWorldGenerator)patchGenIce, (int)1);
        }
        if (genWeakStone) {
            patchGenStone = new PatchGenStone();
            GameRegistry.registerWorldGenerator((IWorldGenerator)patchGenStone, (int)1);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        iceBlocks = new ArrayList();
        for (ItemStack is : OreDictionary.getOres((String)"blockIce")) {
            iceBlocks.add(is.func_77973_b());
        }
    }

    @SubscribeEvent
    public void onBreakerConstruct(AttachCapabilitiesEvent<Entity> evt) {
        final Entity e = (Entity)evt.getObject();
        if (e.field_70170_p != null) {
            if (e.field_70170_p.field_72995_K) {
                if (e instanceof EntityPlayer) {
                    MinecraftForge.EVENT_BUS.register(new Object(){
                        private EntityPlayer ep;
                        private double lastSpeed;
                        {
                            this.ep = (EntityPlayer)e;
                        }

                        @SubscribeEvent(priority=EventPriority.HIGHEST)
                        public void speedUpdate(TickEvent.ClientTickEvent event) {
                            if (event.phase == TickEvent.Phase.START) {
                                double speed = Math.sqrt(this.ep.field_70159_w * this.ep.field_70159_w + this.ep.field_70181_x * this.ep.field_70181_x + this.ep.field_70179_y * this.ep.field_70179_y);
                                if (Math.abs(speed - this.lastSpeed) > 0.01) {
                                    MessageBreakerMovement mbm = new MessageBreakerMovement();
                                    mbm.motionx = this.ep.field_70159_w;
                                    mbm.motiony = this.ep.field_70181_x;
                                    mbm.motionz = this.ep.field_70179_y;
                                    mbm.speed = speed;
                                    PacketHandler.INSTANCE.sendToServer((IMessage)mbm);
                                    this.lastSpeed = speed;
                                }
                                if (this.ep.field_70128_L) {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        }

                        @SubscribeEvent
                        public void killObject(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    });
                }
            } else if (e instanceof EntityPlayer) {
                evt.addCapability(DataReference.PLAYER_BREAK_LOCATION, new ICapabilityProvider(){
                    IPlayerBreakCapability inst = (IPlayerBreakCapability)PLAYERBREAKCAP.getDefaultInstance();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == PLAYERBREAKCAP || capability == BREAKCAP;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        if (capability == PLAYERBREAKCAP || capability == BREAKCAP) {
                            return (T)PLAYERBREAKCAP.cast((Object)this.inst);
                        }
                        return null;
                    }
                });
            } else if (e instanceof EntityLivingBase || e instanceof EntityArrow || e instanceof EntityFireball || e instanceof EntityMinecart || e instanceof EntityFireworkRocket || e instanceof EntityBoat || e instanceof EntityTNTPrimed || e instanceof EntityFallingBlock) {
                evt.addCapability(DataReference.BREAK_LOCATION, new ICapabilityProvider(){
                    IBreakCapability inst = (IBreakCapability)BREAKCAP.getDefaultInstance();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == BREAKCAP;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        return (T)(capability == BREAKCAP ? BREAKCAP.cast((Object)this.inst) : null);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void onTileConstructed(AttachCapabilitiesEvent<TileEntity> evt) {
        TileEntity te = (TileEntity)evt.getObject();
        if (te instanceof TileEntityFragile) {
            if (te instanceof TileEntityThinIce) {
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, new ICapabilityProvider(){
                    IFragileCapability inst = (IFragileCapability)FRAGILECAP.getDefaultInstance();

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FRAGILECAP ? FRAGILECAP.cast((Object)this.inst) : null);
                    }
                });
            } else if (te instanceof TileEntityFragileGlass) {
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            if (speed > 0.165) {
                                te.func_145831_w().func_175655_b(te.func_174877_v(), false);
                            }
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FRAGILECAP ? FRAGILECAP.cast((Object)this.inst) : null);
                    }
                });
            } else if (te instanceof TileEntityWeakStone) {
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            World w = te.func_145831_w();
                            w.func_175684_a(te.func_174877_v(), weakStone, weakStone.func_149738_a(w));
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FRAGILECAP ? FRAGILECAP.cast((Object)this.inst) : null);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void initPlayerBreakerCap(EntityJoinWorldEvent ejwe) {
        Entity e = ejwe.getEntity();
        if (e.hasCapability(PLAYERBREAKCAP, null)) {
            ((IPlayerBreakCapability)e.getCapability(PLAYERBREAKCAP, null)).init(e);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void loadSystem(WorldEvent.Load event) {
        World w = event.getWorld();
        if (!w.field_72995_K) {
            breakSystem = new BreakSystem();
            breakSystem.init(w);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void stopSystem(WorldEvent.Unload event) {
        World w = event.getWorld();
        if (!w.field_72995_K && breakSystem != null) {
            breakSystem.end(w);
        }
    }

    static {
        BREAKCAP = null;
        PLAYERBREAKCAP = null;
        FRAGILECAP = null;
    }
}

