/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import com.fredtargaryen.fragileglass.tileentity.capability.IFragileCapability;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BreakSystem {
    private World world;

    public void init(World world) {
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void end(World world) {
        if (this.world == world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakCheck(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (Entity e : event.world.field_72996_f) {
                double speed;
                if (e.field_70128_L || !e.hasCapability(FragileGlassBase.BREAKCAP, null)) continue;
                IBreakCapability ibc = (IBreakCapability)e.getCapability(FragileGlassBase.BREAKCAP, null);
                ibc.update(e);
                double speedSq = ibc.getSpeedSquared(e);
                if (!this.isValidMoveSpeedSquared(speedSq) || !ibc.isAbleToBreak(e, speed = Math.sqrt(speedSq))) continue;
                this.breakBlocksInWay(e, ibc.getMotionX(e), ibc.getMotionY(e), ibc.getMotionZ(e), speed, ibc.getNoOfBreaks(e));
            }
        }
    }

    private void breakBlocksInWay(Entity e, double xToUse, double yToUse, double zToUse, double distance, byte noOfBreaks) {
        AxisAlignedBB originalAABB = e.func_174813_aQ();
        for (byte breaks = 0; breaks < noOfBreaks; breaks = (byte)(breaks + 1)) {
            AxisAlignedBB aabb = originalAABB;
            double xComp = xToUse / distance;
            double yComp = yToUse / distance;
            double zComp = zToUse / distance;
            while (distance > 1.0) {
                aabb = aabb.func_72317_d(xComp, yComp, zComp);
                this.breakNearbyFragileBlocks(e, aabb, distance -= 1.0);
            }
            originalAABB = originalAABB.func_72317_d(xToUse, yToUse, zToUse);
            this.breakNearbyFragileBlocks(e, originalAABB, distance);
        }
    }

    private void breakNearbyFragileBlocks(Entity e, AxisAlignedBB aabb, double speed) {
        for (double x = Math.floor(aabb.field_72340_a); x < Math.ceil(aabb.field_72336_d); x += 1.0) {
            for (double y = Math.floor(aabb.field_72338_b); y < Math.ceil(aabb.field_72337_e); y += 1.0) {
                for (double z = Math.floor(aabb.field_72339_c); z < Math.ceil(aabb.field_72334_f); z += 1.0) {
                    TileEntity te;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    IBlockState state = e.field_70170_p.func_180495_p(blockPos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a || !block.hasTileEntity(state) || !(te = e.field_70170_p.func_175625_s(blockPos)).hasCapability(FragileGlassBase.FRAGILECAP, null)) continue;
                    ((IFragileCapability)te.getCapability(FragileGlassBase.FRAGILECAP, null)).onCrash(state, te, e, speed);
                }
            }
        }
    }

    private boolean isValidMoveSpeedSquared(double blocksPerTick) {
        return blocksPerTick <= 34.7227348;
    }
}

