/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public abstract class PatchGen
implements IWorldGenerator {
    protected int timeSinceLastPatch;
    protected final int timeToWaitBeforeBonusPatch;
    private int genChance;
    protected int avePatchSize;
    private Block blockToSet;
    private static final double piFraction = 0.5235987755982988;
    private static final double twoPi = Math.PI * 2;

    public PatchGen(int genChance, int avePatchSize, Block blockToSet) {
        this.genChance = genChance;
        this.avePatchSize = avePatchSize;
        this.blockToSet = blockToSet;
        this.timeSinceLastPatch = 0;
        this.timeToWaitBeforeBonusPatch = genChance + 1;
    }

    public abstract void generate(Random var1, int var2, int var3, World var4, IChunkGenerator var5, IChunkProvider var6);

    protected boolean attemptPatch(Random random, int chunkX, int chunkZ, BlockPos patchCentre, World world) {
        if (random.nextInt(this.genChance) == 0 && this.genPatch(random, chunkX, chunkZ, patchCentre, world)) {
            this.timeSinceLastPatch = 0;
            return true;
        }
        if (this.timeSinceLastPatch >= this.timeToWaitBeforeBonusPatch && this.genPatch(random, chunkX, chunkZ, patchCentre, world)) {
            this.timeSinceLastPatch = 0;
            return true;
        }
        ++this.timeSinceLastPatch;
        return false;
    }

    protected boolean genPatch(Random random, int chunkX, int chunkZ, BlockPos patchCentre, World world) {
        BlockPos.MutableBlockPos nextBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        int patchRadius = (int)((2.0 * random.nextGaussian() + (double)this.avePatchSize) / 2.0);
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        double centreX = Math.max(patchCentre.func_177958_n(), chunkBlockX + patchRadius);
        centreX = Math.min(centreX, (double)(chunkBlockX + 16 - patchRadius));
        double centreY = patchCentre.func_177956_o();
        double centreZ = Math.max(patchCentre.func_177952_p(), chunkBlockZ + patchRadius);
        centreZ = Math.min(centreZ, (double)(chunkBlockZ + 16 - patchRadius));
        patchCentre = new BlockPos(centreX, centreY, centreZ);
        for (int rad = patchRadius; rad > 0; --rad) {
            for (double r = 0.0; r < Math.PI * 2; r += 0.5235987755982988) {
                int nextX = (int)(centreX + (double)rad * Math.cos(r));
                int nextZ = (int)(centreZ + (double)rad * Math.sin(r));
                nextBlockPos.func_189532_c((double)nextX, centreY, (double)nextZ);
                Block nextBlock = world.func_180495_p((BlockPos)nextBlockPos).func_177230_c();
                if (!this.isBlockValidToTransform(nextBlock)) continue;
                if (rad > patchRadius - 2) {
                    if (!random.nextBoolean()) continue;
                    world.func_180501_a((BlockPos)nextBlockPos, this.blockToSet.func_176223_P(), 18);
                    continue;
                }
                world.func_180501_a((BlockPos)nextBlockPos, this.blockToSet.func_176223_P(), 18);
            }
        }
        world.func_180501_a(patchCentre, this.blockToSet.func_176223_P(), 18);
        return true;
    }

    protected abstract boolean isBlockValidToTransform(Block var1);
}

