/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.block.BlockFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockFragilePane;
import com.fredtargaryen.fragileglass.block.BlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockStainedFragilePane;
import com.fredtargaryen.fragileglass.block.BlockSugarCauldron;
import com.fredtargaryen.fragileglass.block.BlockThinIce;
import com.fredtargaryen.fragileglass.block.BlockWeakStone;
import com.fredtargaryen.fragileglass.block.SugarBlock;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapFactory;
import com.fredtargaryen.fragileglass.entity.capability.BreakCapStorage;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.IPlayerBreakCapability;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakFactory;
import com.fredtargaryen.fragileglass.entity.capability.PlayerBreakStorage;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragilePane;
import com.fredtargaryen.fragileglass.network.MessageBreakerMovement;
import com.fredtargaryen.fragileglass.network.PacketHandler;
import com.fredtargaryen.fragileglass.proxy.CommonProxy;
import com.fredtargaryen.fragileglass.tileentity.TileEntityFragileGlass;
import com.fredtargaryen.fragileglass.tileentity.TileEntityWeakStone;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapFactory;
import com.fredtargaryen.fragileglass.tileentity.capability.FragileCapStorage;
import com.fredtargaryen.fragileglass.tileentity.capability.IFragileCapability;
import com.fredtargaryen.fragileglass.world.BreakSystem;
import com.fredtargaryen.fragileglass.world.BreakerDataManager;
import com.fredtargaryen.fragileglass.world.FragilityDataManager;
import com.fredtargaryen.fragileglass.worldgen.PatchGen;
import com.fredtargaryen.fragileglass.worldgen.PatchGenIce;
import com.fredtargaryen.fragileglass.worldgen.PatchGenStone;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="fragileglassft", version="2.1.1", name="Fragile Glass and Thin Ice", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
@GameRegistry.ObjectHolder(value="fragileglassft")
public class FragileGlassBase {
    @Mod.Instance(value="fragileglassft")
    public static FragileGlassBase instance;
    public static ArrayList<Item> iceBlocks;
    private static boolean genThinIce;
    public static int avePatchSizeIce;
    public static int genChanceIce;
    private static boolean genWeakStone;
    public static int avePatchSizeStone;
    public static int genChanceStone;
    public static boolean glassShards;
    public static boolean showSuccessMessage;
    private static BreakerDataManager breakerDataManager;
    private static FragilityDataManager fragDataManager;
    private static PatchGen patchGenIce;
    private static PatchGen patchGenStone;
    public static BreakSystem breakSystem;
    public static boolean reposeInstalled;
    @GameRegistry.ObjectHolder(value="fragileglass")
    public static Block fragileGlass;
    @GameRegistry.ObjectHolder(value="fragilepane")
    public static Block fragilePane;
    @GameRegistry.ObjectHolder(value="stainedfragileglass")
    public static Block stainedFragileGlass;
    @GameRegistry.ObjectHolder(value="stainedfragilepane")
    public static Block stainedFragilePane;
    @GameRegistry.ObjectHolder(value="sugarblock")
    public static Block sugarBlock;
    @GameRegistry.ObjectHolder(value="thinice")
    public static Block thinIce;
    @GameRegistry.ObjectHolder(value="sugarcauldron")
    public static Block sugarCauldron;
    @GameRegistry.ObjectHolder(value="weakstone")
    public static Block weakStone;
    @GameRegistry.ObjectHolder(value="fragileglass")
    public static Item iFragileGlass;
    @GameRegistry.ObjectHolder(value="fragilepane")
    public static Item iFragilePane;
    @GameRegistry.ObjectHolder(value="stainedfragileglass")
    public static Item iStainedFragileGlass;
    @GameRegistry.ObjectHolder(value="stainedfragilepane")
    public static Item iStainedFragilePane;
    @GameRegistry.ObjectHolder(value="sugarblock")
    public static Item iSugarBlock;
    @GameRegistry.ObjectHolder(value="thinice")
    public static Item iThinIce;
    @GameRegistry.ObjectHolder(value="sugarcauldron")
    public static Item iSugarCauldron;
    @GameRegistry.ObjectHolder(value="weakstone")
    public static Item iWeakStone;
    @SidedProxy(clientSide="com.fredtargaryen.fragileglass.proxy.ClientProxy", serverSide="com.fredtargaryen.fragileglass.proxy.ServerProxy")
    private static CommonProxy proxy;
    @CapabilityInject(value=IBreakCapability.class)
    public static Capability<IBreakCapability> BREAKCAP;
    @CapabilityInject(value=IPlayerBreakCapability.class)
    public static Capability<IPlayerBreakCapability> PLAYERBREAKCAP;
    @CapabilityInject(value=IFragileCapability.class)
    public static Capability<IFragileCapability> FRAGILECAP;
    private static final ITextComponent SUCCESS_MESSAGE;
    private static final ITextComponent FAILURE_MESSAGE;
    private static ITextComponent STATUS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(IBreakCapability.class, (Capability.IStorage)new BreakCapStorage(), (Callable)new BreakCapFactory());
        CapabilityManager.INSTANCE.register(IPlayerBreakCapability.class, (Capability.IStorage)new PlayerBreakStorage(), (Callable)new PlayerBreakFactory());
        CapabilityManager.INSTANCE.register(IFragileCapability.class, (Capability.IStorage)new FragileCapStorage(), (Callable)new FragileCapFactory());
        MinecraftForge.EVENT_BUS.register((Object)this);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        genThinIce = config.getBoolean("genThinIce", "Worldgen - Thin Ice", true, "If true, thin ice patches will generate on frozen bodies of water");
        avePatchSizeIce = config.getInt("avePatchSizeIce", "Worldgen - Thin Ice", 5, 1, 14, "Average patch diameter");
        genChanceIce = config.getInt("genChanceIce", "Worldgen - Thin Ice", 3, 1, 5, "1 in x chance of patch appearing");
        genWeakStone = config.getBoolean("genWeakStone", "Worldgen - Weak Stone", false, "If true, weak stone patches will generate. Expect falls into lava!");
        avePatchSizeStone = config.getInt("avePatchSizeStone", "Worldgen - Weak Stone", 5, 1, 14, "Average patch diameter");
        genChanceStone = config.getInt("genChanceStone", "Worldgen - Weak Stone", 3, 1, 5, "1 in x chance of patch appearing");
        glassShards = config.getBoolean("glassShards", "Mod Compatibility", false, "If true, broken fragile glass blocks will drop Glass Shards");
        showSuccessMessage = config.getBoolean("showSuccessMessage", "Other", true, "If true, show a message on login if config files loaded successfully");
        config.save();
        breakerDataManager = BreakerDataManager.getInstance();
        breakerDataManager.setupDirsAndFiles(event.getModConfigurationDirectory());
        fragDataManager = FragilityDataManager.getInstance();
        fragDataManager.setupDirsAndFiles(event.getModConfigurationDirectory());
        fragileGlass = (Block)new BlockFragileGlass().func_149663_c("fragileglass").setRegistryName("fragileglass");
        fragilePane = (Block)new BlockFragilePane().func_149663_c("fragilepane").setRegistryName("fragilepane");
        stainedFragileGlass = (Block)new BlockStainedFragileGlass().func_149663_c("stainedfragileglass").setRegistryName("stainedfragileglass");
        stainedFragilePane = (Block)new BlockStainedFragilePane().func_149663_c("stainedfragilepane").setRegistryName("stainedfragilepane");
        sugarBlock = (Block)new SugarBlock().func_149663_c("sugarblock").setRegistryName("sugarblock");
        thinIce = (Block)new BlockThinIce().func_149663_c("thinice").setRegistryName("thinice");
        sugarCauldron = (Block)new BlockSugarCauldron().func_149663_c("sugarcauldron").func_149711_c(5.0f).func_149752_b(10.0f).setRegistryName("sugarcauldron");
        weakStone = (Block)new BlockWeakStone().func_149663_c("weakstone").setRegistryName("weakstone");
        iFragileGlass = (Item)new ItemBlock(fragileGlass).setRegistryName("fragileglass");
        iFragilePane = (Item)new ItemBlock(fragilePane).setRegistryName("fragilepane");
        iStainedFragileGlass = (Item)new ItemBlockStainedFragileGlass(stainedFragileGlass).setRegistryName("stainedfragileglass");
        iStainedFragilePane = (Item)new ItemBlockStainedFragilePane(stainedFragilePane).setRegistryName("stainedfragilepane");
        iSugarBlock = (Item)new ItemBlock(sugarBlock).setRegistryName("sugarblock");
        iThinIce = (Item)new ItemBlock(thinIce).setRegistryName("thinice");
        iSugarCauldron = (Item)new ItemBlock(sugarCauldron).setRegistryName("sugarcauldron");
        iWeakStone = (Item)new ItemBlock(weakStone).setRegistryName("weakstone");
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{fragileGlass, fragilePane, stainedFragileGlass, stainedFragilePane, sugarBlock, thinIce, sugarCauldron, weakStone});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{iFragileGlass, iFragilePane, iStainedFragileGlass, iStainedFragilePane, iSugarBlock, iThinIce, iSugarCauldron, iWeakStone});
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
        proxy.doStateMappings();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityFragileGlass.class, (ResourceLocation)new ResourceLocation("fragileglassft:tefg"));
        GameRegistry.registerTileEntity(TileEntityWeakStone.class, (ResourceLocation)new ResourceLocation("fragileglassft:tews"));
        OreDictionary.registerOre((String)"blockSugar", (Block)sugarBlock);
        if (genThinIce) {
            patchGenIce = new PatchGenIce();
            GameRegistry.registerWorldGenerator((IWorldGenerator)patchGenIce, (int)1);
        }
        if (genWeakStone) {
            patchGenStone = new PatchGenStone();
            GameRegistry.registerWorldGenerator((IWorldGenerator)patchGenStone, (int)1);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        iceBlocks = new ArrayList();
        iceBlocks.addAll(OreDictionary.getOres((String)"blockIce").stream().map(ItemStack::func_77973_b).collect(Collectors.toList()));
        reposeInstalled = Loader.isModLoaded((String)"repose");
    }

    public static boolean reloadDataManagers() {
        breakerDataManager.clearData();
        boolean breaksOK = breakerDataManager.loadEntityData();
        fragDataManager.clearData();
        boolean fragsOK = fragDataManager.loadBlockData();
        return breaksOK && fragsOK;
    }

    @SubscribeEvent
    public void handleMissingMappings(RegistryEvent.MissingMappings evt) {
        block43: {
            String fullName;
            block42: {
                fullName = evt.getName().toString();
                if (!fullName.equals("minecraft:blocks")) break block42;
                for (Object mapping : evt.getAllMappings()) {
                    RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                    if (!trueMapping.key.func_110624_b().equals("ftfragileglass")) continue;
                    switch (trueMapping.key.func_110623_a()) {
                        case "ftfragileglass": {
                            trueMapping.remap((IForgeRegistryEntry)fragileGlass);
                            break;
                        }
                        case "ftfragilepane": {
                            trueMapping.remap((IForgeRegistryEntry)fragilePane);
                            break;
                        }
                        case "ftstainedfragileglass": {
                            trueMapping.remap((IForgeRegistryEntry)stainedFragileGlass);
                            break;
                        }
                        case "ftstainedfragilepane": {
                            trueMapping.remap((IForgeRegistryEntry)stainedFragilePane);
                            break;
                        }
                        case "ftthinice": {
                            trueMapping.remap((IForgeRegistryEntry)thinIce);
                            break;
                        }
                        case "ftweakstone": {
                            trueMapping.remap((IForgeRegistryEntry)weakStone);
                            break;
                        }
                        case "ftsugarcauldron": {
                            trueMapping.remap((IForgeRegistryEntry)sugarCauldron);
                            break;
                        }
                        case "ftsugarblock": {
                            trueMapping.remap((IForgeRegistryEntry)sugarBlock);
                            break;
                        }
                    }
                }
                break block43;
            }
            if (!fullName.equals("minecraft:items")) break block43;
            for (Object mapping : evt.getAllMappings()) {
                RegistryEvent.MissingMappings.Mapping trueMapping = (RegistryEvent.MissingMappings.Mapping)mapping;
                if (!trueMapping.key.func_110624_b().equals("ftfragileglass")) continue;
                switch (trueMapping.key.func_110623_a()) {
                    case "ftfragileglass": {
                        trueMapping.remap((IForgeRegistryEntry)iFragileGlass);
                        break;
                    }
                    case "ftfragilepane": {
                        trueMapping.remap((IForgeRegistryEntry)iFragilePane);
                        break;
                    }
                    case "ftstainedfragileglass": {
                        trueMapping.remap((IForgeRegistryEntry)iStainedFragileGlass);
                        break;
                    }
                    case "ftstainedfragilepane": {
                        trueMapping.remap((IForgeRegistryEntry)iStainedFragilePane);
                        break;
                    }
                    case "ftthinice": {
                        trueMapping.remap((IForgeRegistryEntry)iThinIce);
                        break;
                    }
                    case "ftweakstone": {
                        trueMapping.remap((IForgeRegistryEntry)iWeakStone);
                        break;
                    }
                    case "ftsugarcauldron": {
                        trueMapping.remap((IForgeRegistryEntry)iSugarCauldron);
                        break;
                    }
                    case "ftsugarblock": {
                        trueMapping.remap((IForgeRegistryEntry)iSugarBlock);
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakerConstruct(AttachCapabilitiesEvent<Entity> evt) {
        final Entity e = (Entity)evt.getObject();
        if (e.field_70170_p != null) {
            if (e.field_70170_p.field_72995_K) {
                if (e instanceof EntityPlayer) {
                    MinecraftForge.EVENT_BUS.register(new Object(){
                        private EntityPlayer ep;
                        private double lastSpeed;
                        {
                            this.ep = (EntityPlayer)e;
                        }

                        @SubscribeEvent(priority=EventPriority.HIGHEST)
                        public void speedUpdate(TickEvent.ClientTickEvent event) {
                            if (event.phase == TickEvent.Phase.START) {
                                double speed = Math.sqrt(this.ep.field_70159_w * this.ep.field_70159_w + this.ep.field_70181_x * this.ep.field_70181_x + this.ep.field_70179_y * this.ep.field_70179_y);
                                if (Math.abs(speed - this.lastSpeed) > 0.01) {
                                    MessageBreakerMovement mbm = new MessageBreakerMovement();
                                    mbm.motionx = this.ep.field_70159_w;
                                    mbm.motiony = this.ep.field_70181_x;
                                    mbm.motionz = this.ep.field_70179_y;
                                    mbm.speed = speed;
                                    PacketHandler.INSTANCE.sendToServer((IMessage)mbm);
                                    this.lastSpeed = speed;
                                }
                                if (this.ep.field_70128_L) {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        }

                        @SubscribeEvent
                        public void killObject(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    });
                }
            } else if (e instanceof EntityPlayer) {
                evt.addCapability(DataReference.PLAYER_BREAK_LOCATION, new ICapabilityProvider(){
                    IPlayerBreakCapability inst = (IPlayerBreakCapability)PLAYERBREAKCAP.getDefaultInstance();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == PLAYERBREAKCAP || capability == BREAKCAP;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        if (capability == PLAYERBREAKCAP || capability == BREAKCAP) {
                            return (T)PLAYERBREAKCAP.cast((Object)this.inst);
                        }
                        return null;
                    }
                });
            } else {
                breakerDataManager.addCapabilityIfPossible(e, evt);
            }
        }
    }

    @SubscribeEvent
    public void onTileConstructed(AttachCapabilitiesEvent<TileEntity> evt) {
        TileEntity te = (TileEntity)evt.getObject();
        fragDataManager.addCapabilityIfPossible(te, evt);
    }

    @SubscribeEvent
    public void initPlayerBreakerCap(EntityJoinWorldEvent ejwe) {
        Entity e = ejwe.getEntity();
        if (e.hasCapability(PLAYERBREAKCAP, null)) {
            ((IPlayerBreakCapability)e.getCapability(PLAYERBREAKCAP, null)).init(e);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void loadSystem(WorldEvent.Load event) {
        STATUS = FragileGlassBase.reloadDataManagers() ? SUCCESS_MESSAGE : FAILURE_MESSAGE;
        World w = event.getWorld();
        if (!w.field_72995_K) {
            breakSystem = new BreakSystem();
            breakSystem.init(w);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void stopSystem(WorldEvent.Unload event) {
        World w = event.getWorld();
        if (!w.field_72995_K && breakSystem != null) {
            breakSystem.end(w);
        }
    }

    @Mod.EventHandler
    public void onWorldStart(FMLServerAboutToStartEvent event) {
        breakerDataManager.clearData();
        breakerDataManager.loadEntityData();
        fragDataManager.clearData();
        fragDataManager.loadBlockData();
    }

    @SubscribeEvent
    public void reload(CommandEvent event) {
        if (event.getCommand().func_71517_b().equals("reload")) {
            STATUS = FragileGlassBase.reloadDataManagers() ? SUCCESS_MESSAGE : FAILURE_MESSAGE;
            event.getSender().func_145747_a(STATUS);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer ep = event.player;
        if (ep.func_70003_b(2, "") || ep.field_70170_p.func_73046_m().func_71264_H()) {
            if (STATUS == FAILURE_MESSAGE) {
                ep.func_146105_b(STATUS, false);
            } else if (showSuccessMessage) {
                ep.func_146105_b(STATUS, false);
            }
        }
    }

    static {
        BREAKCAP = null;
        PLAYERBREAKCAP = null;
        FRAGILECAP = null;
        SUCCESS_MESSAGE = new TextComponentString("[FRAGILE GLASS] Data reloaded without errors!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        FAILURE_MESSAGE = new TextComponentString("[FRAGILE GLASS] Errors found in config files; please check config folder for more information.").func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}

