/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.world.BreakerData;
import com.fredtargaryen.fragileglass.world.BreakerDataManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.EntityEntry;

public class BreakerConfigLoader {
    private static final String RES_LOC_REGEX = "[a-z]+:[a-z|_]+";
    private BreakerDataManager manager;
    private HashMap<EntityEntry, BreakerData> entities;

    public BreakerConfigLoader(BreakerDataManager manager, HashMap<EntityEntry, BreakerData> entities) {
        this.manager = manager;
        this.entities = entities;
    }

    public boolean loadFile(BufferedReader br, File configDir, String filename) throws IOException {
        String line;
        int lineNumber = 0;
        ArrayList<String> errors = new ArrayList<String>();
        String errorFileName = configDir.getAbsolutePath() + "/ERRORS_" + filename + ".txt";
        File errorFile = new File(errorFileName);
        if (errorFile.exists()) {
            errorFile.delete();
        }
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if (line.equals("") || line.charAt(0) == '#') continue;
            try {
                String[] values = line.split(" ");
                if (values.length < 3) {
                    throw new BreakerConfigLoadException(filename, "There must be at least 3 values here.", line, lineNumber);
                }
                if (!this.validateEntryName(values[0])) {
                    throw new BreakerConfigLoadException(filename, values[0] + " has the wrong format; please see the examples.", line, lineNumber);
                }
                try {
                    EntityEntry entry;
                    double minSpeedSquared = Double.parseDouble(values[1]);
                    minSpeedSquared = Math.max(minSpeedSquared * minSpeedSquared, 0.0);
                    double maxSpeedSquared = Double.parseDouble(values[2]);
                    maxSpeedSquared = Math.min(maxSpeedSquared * maxSpeedSquared, 34.7227348);
                    if (minSpeedSquared > maxSpeedSquared) {
                        double temp = minSpeedSquared;
                        minSpeedSquared = maxSpeedSquared;
                        maxSpeedSquared = temp;
                    }
                    if ((entry = this.manager.getEntityEntry(values[0])) == null) continue;
                    this.entities.put(entry, new BreakerData(minSpeedSquared, maxSpeedSquared, Arrays.copyOfRange(values, 3, values.length)));
                }
                catch (NumberFormatException nfe) {
                    throw new BreakerConfigLoadException(filename, "One of your speed values can't be read as a decimal number.", line, lineNumber);
                }
            }
            catch (BreakerConfigLoadException bcle) {
                errors.add(bcle.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(errorFile));
            for (String s : errors) {
                bw.write(s + "\n");
            }
            bw.close();
            FMLLog.warning((String)("ERRORS FOUND IN " + filename + "!"), (Object[])new Object[0]);
            FMLLog.warning((String)("Please check config/ERRORS_" + filename + ".txt for more information."), (Object[])new Object[0]);
        }
        return errors.isEmpty();
    }

    private boolean validateEntryName(String entryName) {
        return entryName.matches(RES_LOC_REGEX);
    }

    public class BreakerConfigLoadException
    extends Exception {
        public BreakerConfigLoadException(String filename, String message, String badLine, int lineNumber) {
            super("Error parsing " + filename + " line " + lineNumber + ":\n" + badLine + "\n" + message + "\n");
        }
    }
}

