/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.entity.capability.IBreakCapability;
import com.fredtargaryen.fragileglass.world.BreakerConfigLoader;
import com.fredtargaryen.fragileglass.world.BreakerData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BreakerDataManager {
    private static BreakerDataManager INSTANCE;
    private File configDir;
    private File configFile;
    private HashMap<EntityEntry, BreakerData> entityData = new HashMap();
    private static final String[] defaultFileData;

    public static BreakerDataManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BreakerDataManager();
        }
        return INSTANCE;
    }

    public void addCapabilityIfPossible(Entity e, AttachCapabilitiesEvent<Entity> evt) {
        final BreakerData breakerData = this.getEntityBreakerData(e);
        if (breakerData == null) {
            if (e instanceof EntityLivingBase || e instanceof EntityArrow || e instanceof EntityFireball || e instanceof EntityMinecart || e instanceof EntityFireworkRocket || e instanceof EntityBoat || e instanceof EntityTNTPrimed || e instanceof EntityFallingBlock) {
                evt.addCapability(DataReference.BREAK_LOCATION, new ICapabilityProvider(){
                    IBreakCapability inst = (IBreakCapability)FragileGlassBase.BREAKCAP.getDefaultInstance();

                    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                        return capability == FragileGlassBase.BREAKCAP;
                    }

                    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                        return (T)(capability == FragileGlassBase.BREAKCAP ? FragileGlassBase.BREAKCAP.cast((Object)this.inst) : null);
                    }
                });
            }
        } else {
            ICapabilityProvider iCapProv = new ICapabilityProvider(){
                IBreakCapability inst = new IBreakCapability(){

                    @Override
                    public void init(Entity e) {
                    }

                    @Override
                    public void update(Entity e) {
                    }

                    @Override
                    public double getSpeedSquared(Entity e) {
                        return e.field_70159_w * e.field_70159_w + e.field_70181_x * e.field_70181_x + e.field_70179_y * e.field_70179_y;
                    }

                    @Override
                    public boolean isAbleToBreak(Entity e, double speedSq) {
                        return speedSq >= breakerData.getMinSpeedSquared() && speedSq <= breakerData.getMaxSpeedSquared();
                    }

                    @Override
                    public double getMotionX(Entity e) {
                        return e.field_70159_w;
                    }

                    @Override
                    public double getMotionY(Entity e) {
                        return e.field_70181_x;
                    }

                    @Override
                    public double getMotionZ(Entity e) {
                        return e.field_70179_y;
                    }

                    @Override
                    public byte getNoOfBreaks(Entity e) {
                        return 1;
                    }
                };

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == FragileGlassBase.BREAKCAP;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == FragileGlassBase.BREAKCAP ? FragileGlassBase.BREAKCAP.cast((Object)this.inst) : null);
                }
            };
            evt.addCapability(DataReference.BREAK_LOCATION, iCapProv);
        }
    }

    public void clearData() {
        this.entityData.clear();
    }

    public BreakerData getEntityBreakerData(Entity e) {
        EntityEntry entry = EntityRegistry.getEntry(e.getClass());
        if (this.entityData.containsKey(entry)) {
            return this.entityData.get(entry);
        }
        return null;
    }

    public EntityEntry getEntityEntry(String s) {
        ResourceLocation rl = new ResourceLocation(s);
        if (ForgeRegistries.ENTITIES.containsKey(rl)) {
            return (EntityEntry)ForgeRegistries.ENTITIES.getValue(rl);
        }
        return null;
    }

    private void handleConfigFileException(Exception e) {
        FMLLog.bigWarning((String)"Could not load fragileglassft_entities.cfg! Default entity crash behaviour will be loaded. No custom data will take effect.", (Object[])new Object[0]);
        e.printStackTrace();
        this.loadDefaultData();
    }

    public boolean hasEntityBreakerData() {
        return !this.entityData.isEmpty();
    }

    private void loadDefaultData() {
        this.entityData.clear();
    }

    public boolean loadEntityData() {
        try {
            boolean ok = true;
            BreakerConfigLoader bcl = new BreakerConfigLoader(this, this.entityData);
            File[] fileList = this.configDir.listFiles();
            if (fileList != null) {
                String fileName = this.configFile.getName();
                System.out.println("Found file " + fileName + "; now loading");
                BufferedReader br = new BufferedReader(new FileReader(this.configFile));
                ok &= bcl.loadFile(br, this.configDir, fileName);
                br.close();
                for (File file : fileList) {
                    fileName = file.getName();
                    String[] fileNameParts = fileName.split("_");
                    if (fileNameParts.length != 3) continue;
                    System.out.println("Found file " + fileName + "; now loading");
                    if (!fileNameParts[0].equals("fragileglassft") || !fileNameParts[1].equals("entities")) continue;
                    br = new BufferedReader(new FileReader(file));
                    ok &= bcl.loadFile(br, this.configDir, fileName);
                    br.close();
                }
            }
            return ok;
        }
        catch (IOException ioe) {
            this.handleConfigFileException(new Exception());
            return false;
        }
    }

    public void setupDirsAndFiles(File configDir) {
        this.configDir = configDir;
        this.configFile = new File(this.configDir, "fragileglassft_entities.cfg");
        if (!this.configFile.exists()) {
            try {
                FMLLog.log.warn("[BREAKER CONFIG] No config file found! Writing a new one.");
                FileWriter fw = new FileWriter(this.configFile);
                for (String s : defaultFileData) {
                    fw.write(s);
                }
                fw.close();
            }
            catch (IOException ioe) {
                this.handleConfigFileException(ioe);
            }
        }
    }

    static {
        defaultFileData = new String[]{"###################################################\n", "#FRAGILE GLASS AND THIN ICE CONFIG FILE - ENTITIES#\n", "###################################################\n", "#THINK VERY CAREFULLY AND BACK UP YOUR WORLDS BEFORE ADDING ENTRIES HERE!\n", "#(You probably don't really want to make ZOMBIES ABLE TO BREAK EVERYTHING, for example.)\n", "#Here is where you can configure the speeds required for each entity to break a fragile block.\n", "\n#--Limitations--\n", "#* This will not work for entities which only appear on the client, such as particles.\n", "#* If your entry is not for a valid block, the mod will assume you entered a tile entity. However it\n", "#  cannot check if tile entities are valid, so you won't be warned. Check your spellings carefully.\n", "\n#--How to customise--\n", "#To add a comment to the file, start the line with a # symbol.\n", "#To make an entity able to break fragile blocks, add a new row in this file following this format:\n", "#<modid>:<ID> <min speed> <max speed> <extra values>\n", "#* 'modid:ID' is the ResourceLocation string used to register the entity with Forge.\n", "#  - 'modid' can be found by looking in the 'modid' entry of the mod's mcmod.info file.\n", "#    For vanilla Minecraft this is just 'minecraft'.\n", "#* The first number is a minimum speed (must be decimal). The entity must be moving above this speed\n", "#  for a block to potentially break. Speed is measured in blocks per tick, which is metres per second\n", "#  divided by 20. The minimum for this value is 0.0, i.e. any movement could break a block.\n", "#* The second number is a maximum speed (must be decimal). The entity must be moving below this speed\n", "#  for a block to potentially break. Speed is measured in blocks per tick, which is metres per second\n", "#  divided by 20. The maximum for this value is 5.893: beyond this is faster than chunks can even load.\n", "#* If the max speed is less than the min speed they will be switched around internally.\n", "#* You can add extra values of any format, separated by spaces, for any mod entities that might require\n", "#  them.\n", "\n#--Tips--\n", "#* Certain entities will get a default break speed if not in this file, just so that the file doesn't\n", "#  become totally huge. This applies to: mobs and animals; arrows; fireballs; minecarts; firework\n", "#  rockets; boats; primed TNT; falling blocks. Writing an entity in here will override the default.\n", "#* It is more realistic if the smaller the mob, the larger the break speed.\n", "#* Giving a mob a minimum speed of 0 is risky; a single step towards a fragile block will break it.\n", "\n#--Example lines which you might want to uncomment--\n", "#Let zombies walk through fragile blocks\n", "#minecraft:zombie 0.1 6.0\n"};
    }
}

