/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.DataReference;
import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.tileentity.capability.IFragileCapability;
import com.fredtargaryen.fragileglass.world.FragilityConfigLoader;
import com.fredtargaryen.fragileglass.world.FragilityData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FragilityDataManager {
    private static FragilityDataManager INSTANCE;
    private File configDir;
    private File configFile;
    private HashMap<String, FragilityData> tileEntityData = new HashMap();
    private HashMap<IBlockState, FragilityData> blockStateData = new HashMap();
    private static final String[] defaultFileData;

    public static FragilityDataManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FragilityDataManager();
        }
        return INSTANCE;
    }

    public void addCapabilityIfPossible(TileEntity te, AttachCapabilitiesEvent<TileEntity> evt) {
        FragileBehaviour fb;
        final FragilityData fragData = this.getTileEntityFragilityData(te);
        if (fragData != null && (fb = fragData.getBehaviour()) != FragileBehaviour.MOD && !evt.getCapabilities().containsKey(DataReference.FRAGILE_CAP_LOCATION)) {
            if (fb == FragileBehaviour.BREAK) {
                ICapabilityProvider iCapProv = new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            if (speed > fragData.getBreakSpeed()) {
                                te.func_145831_w().func_175655_b(te.func_174877_v(), true);
                            }
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FragileGlassBase.FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FragileGlassBase.FRAGILECAP ? FragileGlassBase.FRAGILECAP.cast((Object)this.inst) : null);
                    }
                };
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, iCapProv);
            } else if (fb == FragileBehaviour.UPDATE) {
                ICapabilityProvider iCapProv = new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            if (speed > fragData.getBreakSpeed()) {
                                World w = te.func_145831_w();
                                BlockPos tilePos = te.func_174877_v();
                                w.func_175684_a(tilePos, w.func_180495_p(tilePos).func_177230_c(), fragData.getUpdateDelay());
                            }
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FragileGlassBase.FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FragileGlassBase.FRAGILECAP ? FragileGlassBase.FRAGILECAP.cast((Object)this.inst) : null);
                    }
                };
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, iCapProv);
            } else if (fb == FragileBehaviour.CHANGE) {
                ICapabilityProvider iCapProv = new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            if (speed > fragData.getBreakSpeed()) {
                                te.func_145831_w().func_175656_a(te.func_174877_v(), fragData.getNewBlockState());
                            }
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FragileGlassBase.FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FragileGlassBase.FRAGILECAP ? FragileGlassBase.FRAGILECAP.cast((Object)this.inst) : null);
                    }
                };
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, iCapProv);
            } else if (fb == FragileBehaviour.FALL) {
                ICapabilityProvider iCapProv = new ICapabilityProvider(){
                    IFragileCapability inst = new IFragileCapability(){

                        @Override
                        public void onCrash(IBlockState state, TileEntity te, Entity crasher, double speed) {
                            BlockPos pos;
                            World w;
                            if (speed > fragData.getBreakSpeed() && BlockFalling.func_185759_i((IBlockState)(w = te.func_145831_w()).func_180495_p((pos = te.func_174877_v()).func_177977_b()))) {
                                EntityFallingBlock fallingBlock = new EntityFallingBlock(w, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
                                fallingBlock.field_145810_d = te.func_189515_b(new NBTTagCompound());
                                if (FragileGlassBase.reposeInstalled) {
                                    crasher.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                                }
                                w.func_72838_d((Entity)fallingBlock);
                            }
                        }
                    };

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == FragileGlassBase.FRAGILECAP;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        return (T)(capability == FragileGlassBase.FRAGILECAP ? FragileGlassBase.FRAGILECAP.cast((Object)this.inst) : null);
                    }
                };
                evt.addCapability(DataReference.FRAGILE_CAP_LOCATION, iCapProv);
            }
        }
    }

    public void clearData() {
        this.blockStateData.clear();
        this.tileEntityData.clear();
    }

    public FragilityData getBlockStateFragilityData(IBlockState state) {
        if (this.blockStateData.containsKey(state)) {
            return this.blockStateData.get(state);
        }
        return null;
    }

    public FragilityData getTileEntityFragilityData(TileEntity te) {
        String resourceLocationString;
        Class<?> clarse = te.getClass();
        ResourceLocation resourceLocation = TileEntity.func_190559_a(clarse);
        if (resourceLocation != null && this.tileEntityData.containsKey(resourceLocationString = resourceLocation.toString())) {
            return this.tileEntityData.get(resourceLocationString);
        }
        return null;
    }

    private void handleConfigFileException(Exception e) {
        FMLLog.bigWarning((String)"Could not load fragileglassft_blocks.cfg! Default block behaviour will be loaded. No custom data will take effect.", (Object[])new Object[0]);
        e.printStackTrace();
        this.loadDefaultData();
    }

    public boolean hasBlockStateFragilityData() {
        return !this.blockStateData.isEmpty();
    }

    public boolean hasTileEntityFragilityData() {
        return !this.tileEntityData.isEmpty();
    }

    public boolean isResourceLocationValidBlock(String resourceLocation) {
        return ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(resourceLocation));
    }

    private void loadDefaultData() {
        this.blockStateData.clear();
        this.tileEntityData.clear();
        this.tileEntityData.put("fragileglassft:tefg", new FragilityData(FragileBehaviour.BREAK, 0.165, 0, Blocks.field_150350_a.func_176223_P(), new String[0]));
        this.blockStateData.put(FragileGlassBase.thinIce.func_176223_P(), new FragilityData(FragileBehaviour.BREAK, 0.0, 0, Blocks.field_150350_a.func_176223_P(), new String[0]));
        this.tileEntityData.put("fragileglassft:tews", new FragilityData(FragileBehaviour.UPDATE, 0.0, 10, Blocks.field_150350_a.func_176223_P(), new String[0]));
    }

    public boolean loadBlockData() {
        try {
            boolean ok = true;
            FragilityConfigLoader fcl = new FragilityConfigLoader(this, this.blockStateData, this.tileEntityData);
            File[] fileList = this.configDir.listFiles();
            if (fileList != null) {
                String fileName = this.configFile.getName();
                System.out.println("Found file " + fileName + "; now loading");
                BufferedReader br = new BufferedReader(new FileReader(this.configFile));
                ok &= fcl.loadFile(br, this.configDir, fileName);
                br.close();
                for (File file : fileList) {
                    fileName = file.getName();
                    String[] fileNameParts = fileName.split("_");
                    if (fileNameParts.length != 3) continue;
                    System.out.println("Found file " + fileName + "; now loading");
                    if (!fileNameParts[0].equals("fragileglassft") || !fileNameParts[1].equals("blocks")) continue;
                    br = new BufferedReader(new FileReader(file));
                    ok &= fcl.loadFile(br, this.configDir, fileName);
                    br.close();
                }
            }
            return ok;
        }
        catch (IOException ioe) {
            this.handleConfigFileException(new Exception());
            return false;
        }
    }

    public void setupDirsAndFiles(File configDir) {
        this.configDir = configDir;
        this.configFile = new File(this.configDir, "fragileglassft_blocks.cfg");
        if (!this.configFile.exists()) {
            try {
                FMLLog.log.warn("[FRAGILITY CONFIG] No config file found! Writing a new one.");
                FileWriter fw = new FileWriter(this.configFile);
                for (String s : defaultFileData) {
                    fw.write(s);
                }
                fw.close();
            }
            catch (IOException ioe) {
                this.handleConfigFileException(ioe);
            }
        }
    }

    static {
        defaultFileData = new String[]{"#################################################\n", "#FRAGILE GLASS AND THIN ICE CONFIG FILE - BLOCKS#\n", "#################################################\n", "#THINK VERY CAREFULLY AND BACK UP YOUR WORLDS BEFORE ADDING ENTRIES HERE!\n", "#(You probably don't really want to make ALL DIRT BLOCKS fragile, for example.)\n", "#Here is where you can configure which blocks are fragile and which are not, and modify basic behaviour.\n", "\n#--Limitations--\n", "#* This will not work for blocks which are basically air blocks, e.g. Air blocks and 'logic' blocks.\n", "#* If you specify block states you should be as specific as possible; if you leave out a property it\n", "#  will only work for blocks with the properties you specified, and the default for everything else.\n", "#* If your entry is not for a valid block, the mod will assume you entered a tile entity. However it\n", "#  cannot check if tile entities are valid, so you won't be warned. Check your spellings carefully.\n", "\n#--How to customise--\n", "#To add a comment to the file, start the line with a # symbol.\n", "#To make a block fragile, add a new row in this file following this format:\n", "#<modid>:<ID>[properties] <BREAK/UPDATE/CHANGE/FALL/MOD> <min speed> <update delay/new state> <extra values>\n", "#* 'modid:ID' is the ResourceLocation string used to register with Forge.\n", "#  - 'modid' can be found by looking in the 'modid' entry of the mod's mcmod.info file.\n", "#    For vanilla Minecraft this is just 'minecraft'.\n", "#  - If applying the behaviour to a tile entity, prefix the modid with a capital T.\n", "#  - For blocks WITH tile entities, 'ID' is the name used to register the Tile Entity with Forge.\n", "#    You can find these by searching for 'GameRegistry.registerTileEntity' in the mod's source code...\n", "#    or by asking the developer. These are easy to guess in vanilla Minecraft.\n", "#  - For blocks WITHOUT tile entities you need the block's registry name. You can usually find this by\n", "#    looking at the block in-game with the F3 menu on - below it are the blockstate properties.\n", "#    > Only add the properties if you are specifying behaviour for specific blockstates.\n", "#      Not all properties need to be specified; see the door example below.\n", "#* You must choose one of 'BREAK', 'UPDATE', 'CHANGE', 'FALL' or 'MOD'; the block will have one of the\n", "#  following 'crash behaviours':\n", "#  - For all crash behaviours, the 'breaker' entity must be travelling above its minimum speed. If so,\n", "#    it must then be above the speed defined for the block. Meeting both these conditions causes the\n", "#    crash behaviour to trigger.\n", "#  - 'BREAK': the block breaks immediately.\n", "#  - 'UPDATE': a block update is triggered.\n", "#  - 'CHANGE': the block changes into a specified blockstate.\n", "#  - 'FALL': the block falls immediately.\n", "#  - 'MOD': for mod tile entities with custom behaviours ONLY. Modders should make custom tile\n", "#           entities and implement IFragileCapability with the behaviour they want. This mod loads all\n", "#           the extra values and it is up to the modder how they are used. NOTE: If a tile entity has a\n", "#           custom behaviour it will be used regardless of the behaviour value.\n", "#* The first number is a minimum speed (must be decimal). The breaker must be moving above their\n", "#  breaking speed, AND above this speed, to trigger the crash behaviour. Speed is measured in blocks\n", "#  per tick, which is metres per second divided by 20.\n", "#* The second number is only used by the UPDATE behaviour. It must be an integer. It specifies the\n", "#  delay between the collision and the block update. Delays are measured in ticks and there are 20\n", "#  ticks per second.\n", "#* The value after the second number is only used by the CHANGE behaviour. It must be a blockstate\n", "#  (same format as the first value in each line). This is the state the block will change into. If you\n", "#  aren't using this value leave a - here.\n", "#* You can add extra values of any format, separated by spaces, for any mod blocks that might require\n", "#  them.\n", "\n#--Fun example lines you may wish to uncomment--\n", "#Make vanilla glass and ice fragile too\n", "#minecraft:ice BREAK 0.165 0 -\n", "#minecraft:glass BREAK 0.165 0 -\n", "#minecraft:glass_pane BREAK 0.165 0 -\n", "#minecraft:stained_glass BREAK 0.165 0 -\n", "#minecraft:stained_glass_pane BREAK 0.165 0 -\n", "#Make obsidian as fragile as it is IRL\n", "#minecraft:obsidian BREAK 0.165 0 -\n", "#Weak sandstone\n", "#minecraft:sandstone FALL 0.0 0 minecraft:sandstone\n", "#minecraft:red_sandstone FALL 0.0 0 minecraft:red_sandstone\n", "#Burst through doors when sprinting into them\n", "#minecraft:wooden_door[open=false] CHANGE 0.165 0 minecraft:wooden_door[open=true]\n", "#minecraft:birch_door[open=false] CHANGE 0.165 0 minecraft:birch_door[open=true]\n", "#minecraft:acacia_door[open=false] CHANGE 0.165 0 minecraft:acacia_door[open=true]\n", "#minecraft:spruce_door[open=false] CHANGE 0.165 0 minecraft:spruce_door[open=true]\n", "#minecraft:jungle_door[open=false] CHANGE 0.165 0 minecraft:jungle_door[open=true]\n", "#minecraft:dark_oak_door[open=false] CHANGE 0.165 0 minecraft:dark_oak_door[open=true]\n", "#Cause suspended sand to fall when you are near it\n", "#minecraft:sand UPDATE 0.0 10 -\n", "#Safe lava that turns into slime at the last minute\n", "#minecraft:lava CHANGE 0.0 0 minecraft:slime\n", "#\n#--Default values, in case you break something--\n", "#All fragile glass blocks:\n", "#Tfragileglassft:tefg BREAK 0.165 0 -\n", "#Thin ice:\n", "#fragileglassft:thinice BREAK 0.0 0 -\n", "#Weak stone:\n", "#Tfragileglassft:tews UPDATE 0.0 10 -\n\n", "Tfragileglassft:tefg BREAK 0.165 0 -\n", "fragileglassft:thinice BREAK 0.0 0 -\n", "Tfragileglassft:tews UPDATE 0.0 10 -\n"};
    }

    public static enum FragileBehaviour {
        BREAK,
        UPDATE,
        CHANGE,
        FALL,
        MOD;

    }
}

