/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.entity.capability;

import com.fredtargaryen.fragileglass.entity.capability.IPlayerBreakCapability;
import com.fredtargaryen.fragileglass.network.MessageBreakerMovement;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;

public class PlayerBreakFactory
implements Callable<IPlayerBreakCapability> {
    @Override
    public IPlayerBreakCapability call() throws Exception {
        return new PlayerCanBreakImpl();
    }

    private class PlayerCanBreakImpl
    implements IPlayerBreakCapability {
        protected double prevPosX;
        protected double prevPosY;
        protected double prevPosZ;
        private double[] motionVec;
        private double lastDistance;

        private PlayerCanBreakImpl() {
        }

        @Override
        public void init(Entity e) {
            this.prevPosX = e.field_70165_t;
            this.prevPosY = e.field_70163_u;
            this.prevPosZ = e.field_70161_v;
            this.lastDistance = 0.0;
            this.motionVec = new double[]{0.0, 0.0, 0.0};
        }

        @Override
        public void update(Entity e) {
        }

        @Override
        public double getSpeedSquared(Entity e) {
            return this.lastDistance * this.lastDistance;
        }

        @Override
        public boolean isAbleToBreak(Entity e, double speedSq) {
            return speedSq >= 0.018225 && speedSq <= 34.7227348;
        }

        @Override
        public double getMotionX(Entity e) {
            return this.motionVec[0];
        }

        @Override
        public double getMotionY(Entity e) {
            return this.motionVec[1];
        }

        @Override
        public double getMotionZ(Entity e) {
            return this.motionVec[2];
        }

        @Override
        public byte getNoOfBreaks(Entity e) {
            return 3;
        }

        @Override
        public void onMessage(MessageBreakerMovement mbm) {
            this.motionVec[0] = mbm.motionx;
            this.motionVec[1] = mbm.motiony;
            this.motionVec[2] = mbm.motionz;
            this.lastDistance = mbm.speed;
        }
    }
}

