/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.world.BreakerDataManager;
import com.fredtargaryen.fragileglass.world.FragilityData;
import com.fredtargaryen.fragileglass.world.FragilityDataManager;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BreakSystem {
    private World world;
    private BreakerDataManager breakerDataManager;
    private FragilityDataManager fragilityDataManager;
    private boolean hasTileEntityFragilityData;
    private boolean hasBlockStateFragilityData;
    private boolean hasEntityBreakerData;

    public void init(World world) {
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.breakerDataManager = BreakerDataManager.getInstance();
        this.fragilityDataManager = FragilityDataManager.getInstance();
        this.hasEntityBreakerData = this.breakerDataManager.hasEntityBreakerData();
        this.hasTileEntityFragilityData = this.fragilityDataManager.hasTileEntityFragilityData();
        this.hasBlockStateFragilityData = this.fragilityDataManager.hasBlockStateFragilityData();
    }

    public void end(World world) {
        if (this.world == world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakCheck(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CopyOnWriteArrayList entityList = new CopyOnWriteArrayList(event.world.field_72996_f);
            for (Entity e : entityList) {
                if (e.field_70128_L) continue;
                e.getCapability(FragileGlassBase.BREAKCAP).ifPresent(ibc -> {
                    ibc.update(e);
                    double speedSq = ibc.getSpeedSquared(e);
                    if (this.isValidMoveSpeedSquared(speedSq) && ibc.isAbleToBreak(e, speedSq)) {
                        this.breakBlocksInWay(e, ibc.getMotionX(e), ibc.getMotionY(e), ibc.getMotionZ(e), Math.sqrt(speedSq), ibc.getNoOfBreaks(e));
                    }
                });
            }
        }
    }

    private void breakBlocksInWay(Entity e, double xToUse, double yToUse, double zToUse, double distance, byte noOfBreaks) {
        AxisAlignedBB originalAABB = e.func_174813_aQ();
        if (originalAABB != null) {
            for (byte breaks = 0; breaks < noOfBreaks; breaks = (byte)(breaks + 1)) {
                AxisAlignedBB aabb = originalAABB;
                double xComp = xToUse / distance;
                double yComp = yToUse / distance;
                double zComp = zToUse / distance;
                while (distance > 1.0) {
                    aabb = aabb.func_72317_d(xComp, yComp, zComp);
                    this.breakNearbyFragileBlocks(e, aabb, distance -= 1.0);
                }
                originalAABB = originalAABB.func_72317_d(xToUse, yToUse, zToUse);
                this.breakNearbyFragileBlocks(e, originalAABB, distance);
            }
        }
    }

    private void breakNearbyFragileBlocks(Entity e, AxisAlignedBB aabb, double speed) {
        for (double x = Math.floor(aabb.field_72340_a); x < Math.ceil(aabb.field_72336_d); x += 1.0) {
            for (double y = Math.floor(aabb.field_72338_b); y < Math.ceil(aabb.field_72337_e); y += 1.0) {
                for (double z = Math.floor(aabb.field_72339_c); z < Math.ceil(aabb.field_72334_f); z += 1.0) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    IBlockState state = e.field_70170_p.func_180495_p(blockPos);
                    Block block = state.func_177230_c();
                    if (block.isAir(state, (IBlockReader)e.field_70170_p, blockPos)) continue;
                    TileEntity te = e.field_70170_p.func_175625_s(blockPos);
                    if (te == null) {
                        ArrayList<FragilityData> fragilityDataList;
                        if (!this.hasBlockStateFragilityData || (fragilityDataList = this.fragilityDataManager.getBlockStateFragilityData(state)) == null) continue;
                        for (FragilityData fragilityData : fragilityDataList) {
                            if (fragilityData == null || !(speed > fragilityData.getBreakSpeed())) continue;
                            FragilityDataManager.FragileBehaviour fragileBehaviour = fragilityData.getBehaviour();
                            switch (fragileBehaviour) {
                                case BREAK: {
                                    e.field_70170_p.func_175655_b(blockPos, true);
                                    break;
                                }
                                case UPDATE: {
                                    e.field_70170_p.func_205220_G_().func_205360_a(blockPos, (Object)e.field_70170_p.func_180495_p(blockPos).func_177230_c(), fragilityData.getUpdateDelay());
                                    break;
                                }
                                case CHANGE: {
                                    e.field_70170_p.func_175656_a(blockPos, fragilityData.getNewBlockState());
                                }
                                case FALL: {
                                    if (!BlockFalling.func_185759_i((IBlockState)e.field_70170_p.func_180495_p(blockPos.func_177977_b()))) break;
                                    EntityFallingBlock efb = new EntityFallingBlock(e.field_70170_p, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, e.field_70170_p.func_180495_p(blockPos));
                                    e.field_70170_p.func_72838_d((Entity)efb);
                                }
                            }
                        }
                        continue;
                    }
                    if (!this.hasTileEntityFragilityData) continue;
                    te.getCapability(FragileGlassBase.FRAGILECAP).ifPresent(ifc -> ifc.onCrash(state, te, e, speed));
                }
            }
        }
    }

    private boolean isValidMoveSpeedSquared(double blocksPerTick) {
        return blocksPerTick <= 34.7227348;
    }
}

