/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.world.BreakerData;
import com.fredtargaryen.fragileglass.world.BreakerDataManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.entity.EntityType;

public class BreakerConfigLoader {
    private static final String RES_LOC_REGEX = "[a-z]+:[a-z|_]+";
    private BreakerDataManager manager;
    private HashMap<EntityType, BreakerData> entities;

    public BreakerConfigLoader(BreakerDataManager manager, HashMap<EntityType, BreakerData> entities) {
        this.manager = manager;
        this.entities = entities;
    }

    public void loadFile(BufferedReader br, String filename) throws BreakerConfigLoadException, IOException {
        String line;
        int lineNumber = 0;
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] values = line.split(" ");
            if (values.length < 3) {
                throw new BreakerConfigLoadException(filename, "There must be at least 3 values here.", line, lineNumber);
            }
            if (!this.validateEntryName(values[0])) {
                throw new BreakerConfigLoadException(filename, values[0] + " has the wrong format; please see the examples.", line, lineNumber);
            }
            try {
                EntityType entry;
                double minSpeedSquared = Double.parseDouble(values[1]);
                minSpeedSquared = Math.max(minSpeedSquared * minSpeedSquared, 0.0);
                double maxSpeedSquared = Double.parseDouble(values[2]);
                maxSpeedSquared = Math.min(maxSpeedSquared * maxSpeedSquared, 34.7227348);
                if (minSpeedSquared > maxSpeedSquared) {
                    double temp = minSpeedSquared;
                    minSpeedSquared = maxSpeedSquared;
                    maxSpeedSquared = temp;
                }
                if ((entry = this.manager.getEntityType(values[0])) == null) continue;
                this.entities.put(entry, new BreakerData(minSpeedSquared, maxSpeedSquared, Arrays.copyOfRange(values, 3, values.length)));
            }
            catch (NumberFormatException nfe) {
                throw new BreakerConfigLoadException(filename, "One of your speed values can't be read as a decimal number.", line, lineNumber);
            }
        }
    }

    private boolean validateEntryName(String entryName) {
        return entryName.matches(RES_LOC_REGEX);
    }

    public class BreakerConfigLoadException
    extends Exception {
        public BreakerConfigLoadException(String filename, String message, String badLine, int lineNumber) {
            super("Could not load " + filename + " because of line " + lineNumber + ":\n" + badLine + "\n" + message + " Default breaker data will be loaded. The file will not be changed.");
        }
    }
}

