/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.world.FragilityData;
import com.fredtargaryen.fragileglass.world.FragilityDataManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FragilityConfigLoader {
    private static final String RES_LOC_REGEX = "[a-z]+:[a-z|_]+";
    private static final String VARIANT_REGEX = "[a-z]+=([0-9]+|[a-z|_]+)";
    private static final String VARIANTS_REGEX = "([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))";
    private static final String BLOCK_STATE_REGEX = "[a-z]+:[a-z|_]+\\[([a-z]+=([0-9]+|[a-z|_]+),)*([a-z]+=([0-9]+|[a-z|_]+))\\]";
    private FragilityDataManager manager;
    private HashMap<IBlockState, ArrayList<FragilityData>> blockStates;
    private HashMap<String, ArrayList<FragilityData>> tileEntities;

    public FragilityConfigLoader(FragilityDataManager manager, HashMap<IBlockState, ArrayList<FragilityData>> blockStates, HashMap<String, ArrayList<FragilityData>> tileEntities) {
        this.manager = manager;
        this.blockStates = blockStates;
        this.tileEntities = tileEntities;
    }

    private <T> void addNewBehaviour(HashMap<T, ArrayList<FragilityData>> map, T key, FragilityData fragilityData) {
        if (map.containsKey(key)) {
            ArrayList<FragilityData> dataList = map.get(key);
            boolean allowNewBehaviour = true;
            for (FragilityData fdata : dataList) {
                if (fdata.getBehaviour() != fragilityData.getBehaviour()) continue;
                allowNewBehaviour = false;
            }
            if (allowNewBehaviour) {
                dataList.add(fragilityData);
            }
        } else {
            ArrayList<FragilityData> newList = new ArrayList<FragilityData>();
            newList.add(fragilityData);
            map.put(key, newList);
        }
    }

    private <P extends Comparable<P>> IBlockState applyPropertyValue(IBlockState oldState, IBlockState newState, IProperty<P> iprop, HashMap newProperties) {
        if (newState.func_177230_c() == oldState.func_177230_c()) {
            newState = newProperties.containsKey(iprop) ? (IBlockState)newState.func_206870_a(iprop, (Comparable)newProperties.get(iprop)) : (IBlockState)newState.func_206870_a(iprop, oldState.func_177229_b(iprop));
        } else if (newProperties.containsKey(iprop)) {
            newState = (IBlockState)newState.func_206870_a(iprop, (Comparable)newProperties.get(iprop));
        } else {
            String ipropstring = iprop.func_177701_a();
            for (IProperty propkey : oldState.func_206869_a()) {
                String propkeystring;
                Optional opt;
                if (!propkey.func_177701_a().equals(ipropstring) || !(opt = iprop.func_185929_b(propkeystring = oldState.func_177229_b(propkey).toString())).isPresent()) continue;
                newState = (IBlockState)newState.func_206870_a(iprop, (Comparable)opt.get());
            }
        }
        return newState;
    }

    private void addBlockStates(String entryName, FragilityDataManager.FragileBehaviour behaviour, double breakSpeed, int updateDelay, String newStateName, String[] extraData) {
        String[] splitEntryName = entryName.split("\\[");
        Block oldBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitEntryName[0]));
        List<Object> allOldStates = new ArrayList(oldBlock.func_176194_O().func_177619_a());
        if (splitEntryName.length == 2) {
            HashMap<IProperty<?>, ?> oldSpecifiedProperties = this.obtainSpecifiedProperties(oldBlock, splitEntryName[1].split("\\]")[0]);
            for (IProperty<?> iprop : oldSpecifiedProperties.keySet()) {
                allOldStates = allOldStates.stream().filter(state -> state.func_177229_b(iprop) == oldSpecifiedProperties.get(iprop)).collect(Collectors.toList());
            }
        }
        for (IBlockState oldState : allOldStates) {
            String[] splitNewStateName = newStateName.split("\\[");
            Block newBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitNewStateName[0]));
            IBlockState newState = newBlock.func_176223_P();
            HashMap<Object, Object> newSpecifiedProperties = new HashMap();
            if (splitNewStateName.length == 2) {
                newSpecifiedProperties = this.obtainSpecifiedProperties(newBlock, splitNewStateName[1].split("\\]")[0]);
            }
            for (IProperty iprop : newState.func_206869_a()) {
                newState = this.applyPropertyValue(oldState, newState, iprop, newSpecifiedProperties);
            }
            this.addNewBehaviour(this.blockStates, oldState, new FragilityData(behaviour, breakSpeed, updateDelay, newState, extraData));
        }
    }

    public void loadFile(BufferedReader br, String filename) throws FragilityConfigLoadException, IOException {
        String line;
        int lineNumber = 0;
        while ((line = br.readLine()) != null) {
            ++lineNumber;
            if (line.equals("") || line.charAt(0) == '#') continue;
            String[] values = line.split(" ");
            if (values.length < 4) {
                throw new FragilityConfigLoadException(filename, "There must be at least 4 values here.", line, lineNumber);
            }
            if (!this.validateEntryName(values[0])) {
                throw new FragilityConfigLoadException(filename, values[0] + " has the wrong format; please see the examples.", line, lineNumber);
            }
            try {
                FragilityDataManager.FragileBehaviour behaviour = FragilityDataManager.FragileBehaviour.valueOf(values[1]);
                double minSpeed = Math.max(Double.parseDouble(values[2]), 0.0);
                int updateDelay = Math.max(Integer.parseInt(values[3]), 0);
                IBlockState newState = Blocks.field_150350_a.func_176223_P();
                if (!values[4].equals("-") && !this.validateEntryName(values[4])) {
                    throw new FragilityConfigLoadException(filename, values[4] + " has the wrong format; please see the examples.", line, lineNumber);
                }
                if (this.manager.isResourceLocationValidBlock(values[0].split("\\[")[0])) {
                    this.addBlockStates(values[0], behaviour, minSpeed, updateDelay, values[4], Arrays.copyOfRange(values, 5, values.length));
                    continue;
                }
                this.addNewBehaviour(this.tileEntities, values[0], new FragilityData(behaviour, minSpeed, updateDelay, newState, Arrays.copyOfRange(values, 5, values.length)));
            }
            catch (NumberFormatException nfe) {
                throw new FragilityConfigLoadException(filename, values[2] + " can't be read as a decimal number.", line, lineNumber);
            }
            catch (IllegalArgumentException iae) {
                throw new FragilityConfigLoadException(filename, values[1] + " should be 'break', 'update', 'change', 'fall' or 'mod'.", line, lineNumber);
            }
        }
    }

    private boolean isValidBlockOrBlockState(String name, boolean block) {
        return block ? name.matches(RES_LOC_REGEX) : name.matches(BLOCK_STATE_REGEX);
    }

    private HashMap<IProperty<?>, ?> obtainSpecifiedProperties(Block block, @Nullable String propertiesString) {
        HashMap properties = new HashMap();
        if (propertiesString != null) {
            IBlockState state = block.func_176223_P();
            String[] variantInfo = propertiesString.split(",");
            Collection keys = state.func_206869_a();
            for (String variant : variantInfo) {
                String[] info = variant.split("=");
                for (IProperty iprop : keys) {
                    if (!iprop.func_177701_a().equals(info[0])) continue;
                    state = this.parseAndAddProperty(properties, state, iprop, info[1]);
                }
            }
        }
        return properties;
    }

    private <T extends Comparable<T>> IBlockState parseAndAddProperty(HashMap properties, IBlockState state, IProperty<T> iprop, String value) {
        EnumProperty pe;
        Optional opt;
        if (iprop instanceof BooleanProperty) {
            BooleanProperty pb = (BooleanProperty)iprop;
            Optional opt2 = pb.func_185929_b(value);
            if (opt2.isPresent()) {
                properties.put(pb, opt2.get());
            }
        } else if (iprop instanceof IntegerProperty) {
            IntegerProperty pi = (IntegerProperty)iprop;
            Optional opt3 = pi.func_185929_b(value);
            if (opt3.isPresent()) {
                properties.put(pi, opt3.get());
            }
        } else if (iprop instanceof EnumProperty && (opt = (pe = (EnumProperty)iprop).func_185929_b(value)).isPresent()) {
            properties.put(pe, opt.get());
        }
        return state;
    }

    private boolean validateEntryName(String entryName) {
        return this.isValidBlockOrBlockState(entryName, true) || this.isValidBlockOrBlockState(entryName, false);
    }

    public class FragilityConfigLoadException
    extends Exception {
        public FragilityConfigLoadException(String filename, String message, String badLine, int lineNumber) {
            super("Could not load " + filename + " because of line " + lineNumber + ":\n" + badLine + "\n" + message + " Default fragility data will be loaded. The file will not be changed.");
        }
    }
}

