/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.command;

import com.fredtargaryen.fragileglass.command.DataManagerEntry;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.StringTextComponent;

public class DataManagerEntryArgument
implements ArgumentType<DataManagerEntry> {
    public static DataManagerEntryArgument entry() {
        return new DataManagerEntryArgument();
    }

    public DataManagerEntry parse(StringReader reader) throws CommandSyntaxException {
        String[] values = reader.getString().split(" ");
        String manager = values[1];
        String entry = values[2];
        DataManagerEntry dme = new DataManagerEntry();
        CommandSyntaxException cse = new SimpleCommandExceptionType((Message)new StringTextComponent("No " + manager + " found matching this string")).create();
        if (manager.equals("blocks")) {
            try {
                List<BlockState> states = KeyParser.getAllBlockStatesForString(entry);
                if (states.isEmpty()) {
                    throw cse;
                }
                dme.setBlockStateSet(states);
            }
            catch (Exception e) {
                throw cse;
            }
        } else if (manager.equals("entities")) {
            try {
                Collection<EntityType<?>> entityTypes = KeyParser.getAllEntityTypesForString(entry);
                if (entityTypes.isEmpty()) {
                    throw cse;
                }
                dme.setEntityTypeSet(entityTypes);
            }
            catch (Exception e) {
                throw cse;
            }
        } else if (manager.equals("tileentities")) {
            TileEntityType tet = KeyParser.getTileEntityTypeForString(entry);
            if (tet == null) {
                throw cse;
            }
            dme.setTileEntityType(tet);
        }
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return dme;
    }

    public static DataManagerEntry getEntry(CommandContext<CommandSource> context, String name) {
        return (DataManagerEntry)context.getArgument(name, DataManagerEntry.class);
    }
}

