/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.command;

import com.fredtargaryen.fragileglass.command.CommandsBase;
import com.fredtargaryen.fragileglass.command.DataManagerEntry;
import com.fredtargaryen.fragileglass.command.DataManagerEntryArgument;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.DataManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ExportCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(CommandsBase.baseCommandThen("export", (RequiredArgumentBuilder)Commands.func_197056_a((String)"entry", (ArgumentType)DataManagerEntryArgument.entry()).executes(e -> ExportCommand.execute((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"manager"), DataManagerEntryArgument.getEntry((CommandContext<CommandSource>)e, "entry")))));
    }

    private static int execute(CommandSource source, String manager, DataManagerEntry entry) {
        DataManager dm = CommandsBase.getDataManager(manager);
        if (dm == null) {
            return 1;
        }
        StringBuilder sb = new StringBuilder();
        if (manager.equals("blocks")) {
            entry.getBlockStateSet().forEach(state -> {
                try {
                    sb.append(dm.stringifyBehaviour(state, null));
                    sb.append("\n");
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing block state data for " + KeyParser.cleanBlockStateString(state.toString())), false);
                }
            });
        } else if (manager.equals("entities")) {
            entry.getEntityTypeSet().forEach(type -> {
                try {
                    sb.append(dm.stringifyBehaviour(type, null));
                    sb.append("\n");
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing entity data for " + type.getRegistryName()), false);
                }
            });
        } else {
            try {
                sb.append(dm.stringifyBehaviour(entry.getTileEntityType(), null));
                sb.append("\n");
            }
            catch (NullPointerException npe) {
                source.func_197030_a((ITextComponent)new StringTextComponent("No existing tile entity data for " + entry.getTileEntityType().getRegistryName()), false);
            }
        }
        try {
            dm.export(sb.toString());
            source.func_197030_a((ITextComponent)new StringTextComponent("File exported successfully!"), true);
        }
        catch (IOException ioe) {
            source.func_197030_a((ITextComponent)new StringTextComponent("File failed to export."), true);
            return 1;
        }
        return 0;
    }
}

