/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.command;

import com.fredtargaryen.fragileglass.command.CommandsBase;
import com.fredtargaryen.fragileglass.command.DataManagerEntry;
import com.fredtargaryen.fragileglass.command.DataManagerEntryArgument;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.DataManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ViewCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(CommandsBase.baseCommandThen("view", (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"entry", (ArgumentType)DataManagerEntryArgument.entry()).then(CommandsBase.behaviourCommand().executes(e -> ViewCommand.execute((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"manager"), DataManagerEntryArgument.getEntry((CommandContext<CommandSource>)e, "entry"), FragilityData.parseBehaviour(StringArgumentType.getString((CommandContext)e, (String)"behaviour")))))).executes(e -> ViewCommand.execute((CommandSource)e.getSource(), StringArgumentType.getString((CommandContext)e, (String)"manager"), DataManagerEntryArgument.getEntry((CommandContext<CommandSource>)e, "entry"), null))));
    }

    private static int execute(CommandSource source, String manager, DataManagerEntry entry, @Nullable FragilityData.FragileBehaviour behaviour) {
        DataManager dm = CommandsBase.getDataManager(manager);
        if (dm == null) {
            return 1;
        }
        if (manager.equals("blocks")) {
            entry.getBlockStateSet().forEach(state -> {
                try {
                    source.func_197030_a((ITextComponent)new StringTextComponent(dm.stringifyBehaviour(state, behaviour)), false);
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing block state data for " + KeyParser.cleanBlockStateString(state.toString())), false);
                }
            });
        } else if (manager.equals("entities")) {
            entry.getEntityTypeSet().forEach(type -> {
                try {
                    source.func_197030_a((ITextComponent)new StringTextComponent(dm.stringifyBehaviour(type, null)), false);
                }
                catch (NullPointerException npe) {
                    source.func_197030_a((ITextComponent)new StringTextComponent("No existing entity data for " + type.getRegistryName()), false);
                }
            });
        } else {
            try {
                source.func_197030_a((ITextComponent)new StringTextComponent(dm.stringifyBehaviour(entry.getTileEntityType(), behaviour)), false);
            }
            catch (NullPointerException npe) {
                source.func_197030_a((ITextComponent)new StringTextComponent("No existing tile entity data for " + entry.getTileEntityType().getRegistryName()), false);
            }
        }
        return 0;
    }
}

