/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.configloader;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.BreakData;
import com.fredtargaryen.fragileglass.config.behaviour.data.ChangeData;
import com.fredtargaryen.fragileglass.config.behaviour.data.CommandData;
import com.fredtargaryen.fragileglass.config.behaviour.data.DamageData;
import com.fredtargaryen.fragileglass.config.behaviour.data.ExplodeData;
import com.fredtargaryen.fragileglass.config.behaviour.data.FallData;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.data.ModData;
import com.fredtargaryen.fragileglass.config.behaviour.data.UpdateData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;

public abstract class ConfigLoader {
    protected String filename;
    protected int lineNumber;
    protected String line;

    private <P extends Comparable<P>> BlockState applyParsedProperty(BlockState state, IProperty<P> iprop, HashMap newProperties) {
        return (BlockState)state.func_206870_a(iprop, (Comparable)newProperties.get(iprop));
    }

    protected FragilityData createDataFromBehaviour(FragilityData.FragileBehaviour behaviour, double minSpeed) {
        switch (behaviour) {
            case BREAK: {
                return new BreakData(minSpeed);
            }
            case CHANGE: {
                return new ChangeData(minSpeed);
            }
            case COMMAND: {
                return new CommandData(minSpeed);
            }
            case DAMAGE: {
                return new DamageData(minSpeed);
            }
            case EXPLODE: {
                return new ExplodeData(minSpeed);
            }
            case FALL: {
                return new FallData(minSpeed);
            }
            case MOD: {
                return new ModData(minSpeed);
            }
            case UPDATE: {
                return new UpdateData(minSpeed);
            }
        }
        return new BreakData(minSpeed);
    }

    public BlockState getNewStateFromOldAndString(BlockState old, String stateString) throws ConfigLoadException {
        HashMap<String, String> description = KeyParser.getDescriptionFromString(stateString);
        String blockString = description.get("block");
        BlockState newState = KeyParser.getBlockFromString(blockString).func_176223_P();
        if (newState == Blocks.field_150350_a.func_176223_P() && !blockString.equals("minecraft:air")) {
            if (blockString.equals("-")) {
                newState = old;
            } else {
                throw new ConfigLoadException("Could not find a block state matching " + blockString);
            }
        }
        HashMap<String, String> newMap = KeyParser.getStringPropertyMapFrom(newState);
        HashMap<String, String> oldMap = KeyParser.getStringPropertyMapFrom(old);
        HashMap<String, String> setMap = KeyParser.getStringPropertyMapFrom(description.get("properties"));
        this.updateStringPropertyMap(newMap, oldMap);
        this.updateStringPropertyMap(newMap, setMap);
        HashMap<IProperty<?>, Object> parsedMap = KeyParser.parseStringPropertyMap(newState, newMap);
        for (IProperty<?> prop : parsedMap.keySet()) {
            newState = this.applyParsedProperty(newState, prop, parsedMap);
        }
        return newState;
    }

    public BlockState getSingleBlockStateFromString(String stateString) throws ConfigLoadException {
        HashMap<String, String> description = KeyParser.getDescriptionFromString(stateString);
        String blockString = description.get("block");
        if (blockString.equals("-")) {
            return Blocks.field_150350_a.func_176223_P();
        }
        BlockState state = KeyParser.getBlockFromString(blockString).func_176223_P();
        return this.getNewStateFromOldAndString(state, stateString);
    }

    public final boolean loadFile(BufferedReader br, File configDir, String filename) throws IOException {
        this.filename = filename;
        this.lineNumber = 0;
        ArrayList<String> errors = new ArrayList<String>();
        String errorFileName = configDir.getAbsolutePath() + "/ERRORS_" + filename + ".txt";
        File errorFile = new File(errorFileName);
        if (errorFile.exists()) {
            errorFile.delete();
        }
        while ((this.line = br.readLine()) != null) {
            ++this.lineNumber;
            if (this.line.equals("") || this.line.charAt(0) == '@') continue;
            try {
                this.parseLine();
            }
            catch (ConfigLoadException cle) {
                errors.add(cle.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(errorFile));
            for (String s : errors) {
                bw.write(s + "\n");
            }
            bw.close();
            FragileGlassBase.error("[FRAGILE GLASS] ERRORS FOUND IN " + filename + "!");
            FragileGlassBase.error("[FRAGILE GLASS] Please check config/ERRORS_" + filename + ".txt for more information.");
        }
        this.filename = null;
        this.line = null;
        this.lineNumber = 0;
        return errors.isEmpty();
    }

    public void parseArbitraryString(String string) throws ConfigLoadException {
        this.line = string;
        this.lineNumber = -1;
        this.filename = "";
        this.parseLine();
    }

    protected abstract void parseLine() throws ConfigLoadException;

    protected void updateStringPropertyMap(HashMap<String, String> toUpdate, HashMap<String, String> newProps) {
        for (String key : newProps.keySet()) {
            toUpdate.replace(key, newProps.get(key));
        }
    }

    public class ConfigLoadException
    extends Exception {
        public String shortMessage;

        public ConfigLoadException(String message) {
            super(ConfigLoader.this.lineNumber == -1 ? "Could not parse command: \n" + ConfigLoader.this.line + "\n" + message + "\nNo changes have been made." : "Error parsing " + ConfigLoader.this.filename + " line " + ConfigLoader.this.lineNumber + ":\n" + ConfigLoader.this.line + "\n" + message + "\n");
            this.shortMessage = message;
        }
    }
}

