/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;

public class DamageData
extends FragilityData {
    private DamageSource damageSource;
    private float damageAmount;
    private boolean speedScale;

    public DamageData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.DAMAGE;
    }

    @Override
    public void parseExtraData(@Nullable BlockState state, ConfigLoader cl, String ... extraData) throws FragilityData.FragilityDataParseException {
        this.lengthCheck(extraData, 3);
        this.damageSource = this.parseDamageSource(extraData[0]);
        try {
            this.damageAmount = Float.parseFloat(extraData[1]);
        }
        catch (NumberFormatException nfe) {
            throw new FragilityData.FragilityDataParseException(this, "Damage amount (" + extraData[1] + ") must be a number.");
        }
        try {
            this.speedScale = Boolean.parseBoolean(extraData[2]);
        }
        catch (Exception e) {
            throw new FragilityData.FragilityDataParseException(this, "Speed scale (" + extraData[2] + ") must be true if you want damage to scale with speed, or false otherwise.");
        }
    }

    @Override
    public void onCrash(@Nullable BlockState state, @Nullable TileEntity te, BlockPos pos, Entity crasher, double speedSq) {
        crasher.func_70097_a(this.damageSource, this.speedScale ? (float)((double)this.damageAmount * Math.sqrt(speedSq)) : this.damageAmount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " ");
        sb.append(this.damageSource.field_76373_n.toLowerCase());
        sb.append(" ");
        sb.append(this.damageAmount);
        sb.append(" ");
        sb.append(this.speedScale);
        return sb.toString();
    }

    private DamageSource parseDamageSource(String sourceString) throws FragilityData.FragilityDataParseException {
        String lowerString;
        switch (lowerString = sourceString.toLowerCase()) {
            case "infire": {
                return DamageSource.field_76372_a;
            }
            case "lightningbolt": {
                return DamageSource.field_180137_b;
            }
            case "onfire": {
                return DamageSource.field_76370_b;
            }
            case "lava": {
                return DamageSource.field_76371_c;
            }
            case "hotfloor": {
                return DamageSource.field_190095_e;
            }
            case "inwall": {
                return DamageSource.field_76368_d;
            }
            case "cramming": {
                return DamageSource.field_191291_g;
            }
            case "drown": {
                return DamageSource.field_76369_e;
            }
            case "starve": {
                return DamageSource.field_76366_f;
            }
            case "cactus": {
                return DamageSource.field_76367_g;
            }
            case "fall": {
                return DamageSource.field_76379_h;
            }
            case "flyintowall": {
                return DamageSource.field_188406_j;
            }
            case "outofworld": {
                return DamageSource.field_76380_i;
            }
            case "generic": {
                return DamageSource.field_76377_j;
            }
            case "magic": {
                return DamageSource.field_76376_m;
            }
            case "wither": {
                return DamageSource.field_82727_n;
            }
            case "anvil": {
                return DamageSource.field_82728_o;
            }
            case "fallingblock": {
                return DamageSource.field_82729_p;
            }
            case "dragonbreath": {
                return DamageSource.field_188407_q;
            }
            case "fireworks": {
                return DamageSource.field_191552_t;
            }
            case "dryout": {
                return DamageSource.field_205132_u;
            }
            case "sweetberrybush": {
                return DamageSource.field_220302_v;
            }
        }
        throw new FragilityData.FragilityDataParseException(this, "No damage source found. Please remove any underscores.");
    }
}

