/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;

public class ExplodeData
extends FragilityData {
    private float strength;

    public ExplodeData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.EXPLODE;
    }

    @Override
    public void parseExtraData(@Nullable BlockState state, ConfigLoader cl, String ... extraData) throws FragilityData.FragilityDataParseException {
        Float f;
        this.lengthCheck(extraData, 1);
        try {
            f = Float.valueOf(Float.parseFloat(extraData[0]));
        }
        catch (NumberFormatException nfe) {
            throw new FragilityData.FragilityDataParseException(this, extraData[0] + "must be a decimal between 1 and 100 inclusive.");
        }
        this.strength = Math.max(Math.min(f.floatValue(), 100.0f), 1.0f);
    }

    @Override
    public void onCrash(@Nullable BlockState state, @Nullable TileEntity te, BlockPos pos, Entity crasher, double speedSq) {
        if (speedSq > this.breakSpeedSq) {
            crasher.field_70170_p.func_217385_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.strength, Explosion.Mode.BREAK);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.strength;
    }
}

