/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateData
extends FragilityData {
    private int updateDelay;

    public UpdateData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.UPDATE;
    }

    @Override
    public void parseExtraData(@Nullable BlockState state, ConfigLoader cl, String ... extraData) throws FragilityData.FragilityDataParseException {
        this.lengthCheck(extraData, 1);
        try {
            this.updateDelay = Math.max(Integer.parseInt(extraData[0]), 0);
        }
        catch (NumberFormatException nfe) {
            throw new FragilityData.FragilityDataParseException("Update delay (" + extraData[0] + ") must be a number.");
        }
    }

    @Override
    public void onCrash(@Nullable BlockState state, @Nullable TileEntity te, BlockPos pos, Entity crasher, double speedSq) {
        if (speedSq > this.breakSpeedSq) {
            crasher.field_70170_p.func_205220_G_().func_205360_a(pos, (Object)crasher.field_70170_p.func_180495_p(pos).func_177230_c(), this.updateDelay);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " ");
        sb.append(this.updateDelay);
        return sb.toString();
    }
}

