/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.world;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.BlockDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.EntityDataManager;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.TileEntityDataManager;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BreakSystem {
    private World world;
    private BlockDataManager blockDataManager;
    private EntityDataManager entityDataManager;
    private TileEntityDataManager tileEntityDataManager;

    public void init(World world) {
        this.world = world;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.blockDataManager = FragileGlassBase.getBlockDataManager();
        this.entityDataManager = FragileGlassBase.getEntityDataManager();
        this.tileEntityDataManager = FragileGlassBase.getTileEntityDataManager();
    }

    public void end(World world) {
        if (this.world == world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakCheck(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CopyOnWriteArrayList entityList = new CopyOnWriteArrayList(((ServerWorld)event.world).getEntities().collect(Collectors.toList()));
            for (Entity e : entityList) {
                if (e.field_70128_L) continue;
                e.getCapability(FragileGlassBase.BREAKCAP).ifPresent(ibc -> {
                    ibc.update(e);
                    double speedSq = ibc.getSpeedSquared(e);
                    if (this.isValidMoveSpeedSquared(speedSq) && ibc.isAbleToBreak(e, speedSq)) {
                        this.breakBlocksInWay(e, ibc.getMotionX(e), ibc.getMotionY(e), ibc.getMotionZ(e), speedSq, ibc.getNoOfBreaks(e));
                    }
                });
            }
        }
    }

    private void breakBlocksInWay(Entity e, double xToUse, double yToUse, double zToUse, double speedSq, byte noOfBreaks) {
        AxisAlignedBB originalAABB = e.func_174813_aQ();
        if (originalAABB != null) {
            double distance = Math.sqrt(speedSq);
            for (byte breaks = 0; breaks < noOfBreaks; breaks = (byte)(breaks + 1)) {
                AxisAlignedBB aabb = originalAABB;
                double xComp = xToUse / distance;
                double yComp = yToUse / distance;
                double zComp = zToUse / distance;
                while (distance > 1.0) {
                    aabb = aabb.func_72317_d(xComp, yComp, zComp);
                    this.breakNearbyFragileBlocks(e, aabb, (distance -= 1.0) * distance);
                }
                originalAABB = originalAABB.func_72317_d(xToUse, yToUse, zToUse);
                this.breakNearbyFragileBlocks(e, originalAABB, distance * distance);
            }
        }
    }

    private void breakNearbyFragileBlocks(Entity e, AxisAlignedBB aabb, double speedSq) {
        for (double x = Math.floor(aabb.field_72340_a); x < Math.ceil(aabb.field_72336_d); x += 1.0) {
            for (double y = Math.floor(aabb.field_72338_b); y < Math.ceil(aabb.field_72337_e); y += 1.0) {
                for (double z = Math.floor(aabb.field_72339_c); z < Math.ceil(aabb.field_72334_f); z += 1.0) {
                    ArrayList fragilityDataList;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState state = e.field_70170_p.func_180495_p(blockPos);
                    Block block = state.func_177230_c();
                    if (block.isAir(state, (IBlockReader)e.field_70170_p, blockPos)) continue;
                    TileEntity te = e.field_70170_p.func_175625_s(blockPos);
                    if (te == null) {
                        fragilityDataList = (ArrayList)this.blockDataManager.getData(state);
                        if (fragilityDataList == null) continue;
                        for (FragilityData fragilityData : fragilityDataList) {
                            fragilityData.onCrash(state, null, blockPos, e, speedSq);
                        }
                        continue;
                    }
                    fragilityDataList = (ArrayList)this.tileEntityDataManager.getData(te.func_200662_C());
                    if (fragilityDataList == null) continue;
                    for (FragilityData fragilityData : fragilityDataList) {
                        fragilityData.onCrash(null, te, blockPos, e, speedSq);
                    }
                }
            }
        }
    }

    private boolean isValidMoveSpeedSquared(double blocksPerTick) {
        return blocksPerTick <= 34.72273476;
    }
}

