/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.worldgen.IcePatchPlacementConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;

public class IcePatchPlacement
extends Placement<IcePatchPlacementConfig> {
    private static final ResourceLocation ICE_TAG = new ResourceLocation("minecraft", "ice");

    public IcePatchPlacement(Function<Dynamic<?>, ? extends IcePatchPlacementConfig> func) {
        super(func);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> iChunkGenerator, Random random, IcePatchPlacementConfig icePatchPlacementConfig, BlockPos blockPos) {
        if (random.nextInt(icePatchPlacementConfig.genChance) == 0) {
            BlockPos surfacePos;
            Biome b;
            if (FragileGlassBase.ICE_BLOCKS == null) {
                FragileGlassBase.ICE_BLOCKS = BlockTags.func_199896_a().func_199915_b(ICE_TAG);
            }
            if ((b = world.func_180494_b(surfacePos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, blockPos).func_177977_b())).func_180626_a(surfacePos) < 0.015f) {
                int chunkBlockX = surfacePos.func_177958_n() / 16 * 16;
                int chunkBlockZ = surfacePos.func_177952_p() / 16 * 16;
                int candX = chunkBlockX;
                int candZ = chunkBlockZ;
                boolean done = false;
                while (!done) {
                    BlockPos pos = new BlockPos(candX, 256, candZ);
                    boolean stop = false;
                    while (!stop) {
                        if (world.func_180495_p(pos = pos.func_177977_b()).isAir((IBlockReader)world, pos) && pos.func_177956_o() != -1) continue;
                        stop = true;
                    }
                    if (pos.func_177956_o() < 0) continue;
                    BlockPos patchCentre = pos;
                    BlockState candidate = world.func_180495_p(patchCentre);
                    if (this.isBlockValidToTransform(candidate.func_177230_c())) {
                        return Stream.of(patchCentre);
                    }
                    if (candX > chunkBlockX + 15) {
                        done = true;
                        continue;
                    }
                    if (candZ > chunkBlockZ + 15) {
                        candX += 2;
                        candZ = chunkBlockZ;
                        continue;
                    }
                    candZ += 2;
                }
            }
        }
        return Stream.empty();
    }

    private boolean isBlockValidToTransform(Block block) {
        return block == Blocks.field_150355_j || FragileGlassBase.ICE_BLOCKS.func_199685_a_((Object)block);
    }
}

