/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.worldgen.StonePatchGenConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class StonePatchGen
extends Feature<StonePatchGenConfig> {
    private static final double TWOPI = Math.PI * 2;
    private static final double PIFRACTION = 0.5235987755982988;

    public StonePatchGen(Function<Dynamic<?>, ? extends StonePatchGenConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGen, Random random, BlockPos pos, StonePatchGenConfig config) {
        BlockPos.MutableBlockPos nextBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        int patchRadius = (int)((2.0 * random.nextGaussian() + (double)config.avePatchSize) / 2.0);
        BlockPos patchCentre = pos;
        int cornerX = patchCentre.func_177958_n() / 16 * 16;
        int cornerZ = patchCentre.func_177952_p() / 16 * 16;
        double centreX = Math.max(patchCentre.func_177958_n(), cornerX + patchRadius);
        centreX = Math.min(centreX, (double)(cornerX + 16 - patchRadius));
        double centreY = patchCentre.func_177956_o();
        double centreZ = Math.max(patchCentre.func_177952_p(), cornerZ + patchRadius);
        centreZ = Math.min(centreZ, (double)(cornerZ + 16 - patchRadius));
        patchCentre = new BlockPos(centreX, centreY, centreZ);
        for (int rad = patchRadius; rad > 0; --rad) {
            for (double r = 0.0; r < Math.PI * 2; r += 0.5235987755982988) {
                int nextX = (int)(centreX + (double)rad * Math.cos(r));
                int nextZ = (int)(centreZ + (double)rad * Math.sin(r));
                nextBlockPos.func_189532_c((double)nextX, centreY, (double)nextZ);
                BlockState nextBlockState = world.func_180495_p((BlockPos)nextBlockPos);
                if (nextBlockState.func_185904_a() != Material.field_151576_e) continue;
                if (rad > patchRadius - 2) {
                    if (!random.nextBoolean()) continue;
                    world.func_180501_a((BlockPos)nextBlockPos, FragileGlassBase.WEAK_STONE.func_176223_P(), 18);
                    continue;
                }
                world.func_180501_a((BlockPos)nextBlockPos, FragileGlassBase.WEAK_STONE.func_176223_P(), 18);
            }
        }
        world.func_180501_a(patchCentre, FragileGlassBase.WEAK_STONE.func_176223_P(), 18);
        return true;
    }
}

