/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.worldgen.StonePatchPlacementConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;

public class StonePatchPlacement
extends Placement<StonePatchPlacementConfig> {
    public StonePatchPlacement(Function<Dynamic<?>, ? extends StonePatchPlacementConfig> func) {
        super(func);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> chunkGen, Random random, StonePatchPlacementConfig stonePatchPlacementConfig, BlockPos blockPos) {
        int cornerX = blockPos.func_177958_n() / 16 * 16;
        int cornerZ = blockPos.func_177952_p() / 16 * 16;
        boolean previousBlockSolid = true;
        BlockPos patchCentre = new BlockPos(cornerX + random.nextInt(16), 0, cornerZ + random.nextInt(16));
        for (int y = 0; y < 256; ++y) {
            if (world.func_180495_p(patchCentre).func_185904_a().func_76220_a()) {
                if (!previousBlockSolid) {
                    previousBlockSolid = true;
                    BlockState candidate = world.func_180495_p(patchCentre);
                    if (candidate.func_185904_a() == Material.field_151576_e) {
                        return Stream.of(patchCentre);
                    }
                }
            } else if (previousBlockSolid) {
                previousBlockSolid = false;
            }
            patchCentre = patchCentre.func_177984_a();
        }
        return Stream.empty();
    }
}

