/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.configloader;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.BlockDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockState;

public class BlockConfigLoader
extends ConfigLoader {
    private BlockDataManager manager;
    private HashMap<BlockState, ArrayList<FragilityData>> blockStates;

    public BlockConfigLoader(BlockDataManager manager, HashMap<BlockState, ArrayList<FragilityData>> blockStates) {
        this.manager = manager;
        this.blockStates = blockStates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryAddNewBehaviour(BlockState key, FragilityData fragilityData) throws ConfigLoader.ConfigLoadException {
        if (this.blockStates.containsKey(key)) {
            ArrayList<FragilityData> dataList = this.blockStates.get(key);
            if (fragilityData.canBeQueued()) {
                dataList.add(fragilityData);
                return;
            } else {
                boolean add = false;
                for (FragilityData fd : dataList) {
                    add |= fd.getBehaviour() == FragilityData.FragileBehaviour.WAIT;
                }
                if (!add) throw new ConfigLoader.ConfigLoadException(this, "This behaviour type can't be added when a wait behaviour has been previously added.\nIt may depend on data which may not exist by the time the wait is over.\nCheck the config file for more information on wait.");
                dataList.add(fragilityData);
            }
            return;
        } else {
            ArrayList<FragilityData> newList = new ArrayList<FragilityData>();
            newList.add(fragilityData);
            this.blockStates.put(key, newList);
        }
    }

    @Override
    protected void parseLine() throws ConfigLoader.ConfigLoadException {
        String[] values = this.line.split(" ");
        if (values.length < 3) {
            throw new ConfigLoader.ConfigLoadException(this, "There must be at least 3 values here.");
        }
        List<BlockState> states = KeyParser.getAllBlockStatesForString(values[0]);
        if (states.isEmpty()) {
            throw new ConfigLoader.ConfigLoadException(this, "No BlockStates were found for the description '" + values[0] + "'.");
        }
        try {
            FragilityData.FragileBehaviour behaviour = FragilityData.FragileBehaviour.valueOf(values[1].toUpperCase());
            double minSpeed = Math.max(Double.parseDouble(values[2]), 0.0);
            for (BlockState state : states) {
                FragilityData newData = this.createDataFromBehaviour(behaviour, minSpeed);
                newData.parseExtraData(state, this, Arrays.copyOfRange(values, 3, values.length));
                this.tryAddNewBehaviour(state, newData);
            }
        }
        catch (FragilityData.FragilityDataParseException fdpe) {
            throw new ConfigLoader.ConfigLoadException(this, fdpe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new ConfigLoader.ConfigLoadException(this, values[2] + " can't be read as a decimal number.");
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigLoader.ConfigLoadException(this, values[1] + " should be break, change, command, damage, explode, fall, mod, update or wait.");
        }
    }
}

