/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.configloader;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.KeyParser;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import com.fredtargaryen.fragileglass.config.behaviour.datamanager.TileEntityDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntityType;

public class TileEntityConfigLoader
extends ConfigLoader {
    private TileEntityDataManager manager;
    private HashMap<TileEntityType, ArrayList<FragilityData>> tileEntities;

    public TileEntityConfigLoader(TileEntityDataManager manager, HashMap<TileEntityType, ArrayList<FragilityData>> tileEntities) {
        this.manager = manager;
        this.tileEntities = tileEntities;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryAddNewBehaviour(TileEntityType key, FragilityData fragilityData) throws ConfigLoader.ConfigLoadException {
        if (this.tileEntities.containsKey(key)) {
            ArrayList<FragilityData> dataList = this.tileEntities.get(key);
            if (fragilityData.canBeQueued()) {
                dataList.add(fragilityData);
                return;
            } else {
                boolean add = false;
                for (FragilityData fd : dataList) {
                    add |= fd.getBehaviour() == FragilityData.FragileBehaviour.WAIT;
                }
                if (!add) throw new ConfigLoader.ConfigLoadException("This behaviour type can't be added when a wait behaviour has been previously added.\nIt may depend on data which may not exist by the time the wait is over.\nCheck the config file for more information on wait.");
                dataList.add(fragilityData);
            }
            return;
        } else {
            ArrayList<FragilityData> newList = new ArrayList<FragilityData>();
            newList.add(fragilityData);
            this.tileEntities.put(key, newList);
        }
    }

    @Override
    protected void parseLine() throws ConfigLoader.ConfigLoadException {
        String[] values = this.line.split(" ");
        if (values.length < 3) {
            throw new ConfigLoader.ConfigLoadException("There must be at least 3 values here.");
        }
        TileEntityType entry = KeyParser.getTileEntityTypeForString(values[0]);
        if (entry == null) {
            throw new ConfigLoader.ConfigLoadException(values[0] + " has the wrong format; please see the examples.");
        }
        try {
            FragilityData.FragileBehaviour behaviour = FragilityData.FragileBehaviour.valueOf(values[1].toUpperCase());
            double minSpeed = Math.max(Double.parseDouble(values[2]), 0.0);
            FragilityData newData = this.createDataFromBehaviour(behaviour, minSpeed);
            newData.parseExtraData(null, this, Arrays.copyOfRange(values, 3, values.length));
            this.tryAddNewBehaviour(entry, newData);
        }
        catch (FragilityData.FragilityDataParseException fdpe) {
            throw new ConfigLoader.ConfigLoadException(fdpe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new ConfigLoader.ConfigLoadException(values[2] + " can't be read as a decimal number.");
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigLoader.ConfigLoadException(values[1] + " should be break, change, command, damage, explode, fall, mod, update or wait.");
        }
    }
}

